﻿using Newtonsoft.Json;

namespace Bailun.Core.Extension.Page.Jqgrid
{
    /// <summary>
    /// 用于jqgrid列表的请求参数
    /// </summary>
    public class JqgridPageRequest
    {
        /// <summary>
        /// 每页行数
        /// </summary>
        [JsonProperty("rows")]
        public int PageNumber { get; set; } = 20;

        /// <summary>
        /// 当前页
        /// </summary>
        [JsonProperty("page")]
        public int PageIndex { get; set; }
        /// <summary>
        /// 排序列
        /// </summary>
        [JsonProperty("sidx")]
        public string Order { get; set; }
        /// <summary>
        /// 排序类型
        /// </summary>
        [JsonProperty("sord")]
        public string OrderType { get; set; }
        /// <summary>
        /// 总记录数
        /// </summary>
        [JsonProperty("records")]
        public long Records { get; set; }
        /// <summary>
        /// 总页数
        /// </summary>
        [JsonProperty("total")]
        public long Total
        {
            get
            {
                if (Records > 0)
                {
                    return Records % this.PageNumber == 0 ? Records / this.PageNumber : Records / this.PageNumber + 1;
                }
                else
                {
                    return 0;
                }
            }
        }
        /// <summary>
        /// 查询条件Json
        /// </summary>
        [JsonProperty("conditionJson")]
        public string ConditionJson { get; set; }
        /// <summary>
        /// 查询关键词
        /// </summary>
        [JsonProperty("searchKeyWord")]
        public string SearchKeyWord { get; set; }
        /// <summary>
        /// 是否首次请求（便于部分返回值做缓存，二次请求无需加载）
        /// </summary>
        [JsonProperty("isFirstRequest")]
        public bool IsFirstRequest { get; set; }
    }
}

