﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace Bailun.Core.Extension.Linq
{
  public  class CommonEqualityComparer<T, V> : IEqualityComparer<T>
  {
      private Func<T, V> keySelector;
      private IEqualityComparer<V> comparer;

      public CommonEqualityComparer(Func<T, V> keySelector, IEqualityComparer<V> comparer)
      {
          this.keySelector = keySelector;
          this.comparer = comparer;
      }

      public CommonEqualityComparer(Func<T, V> keySelector)
          : this(keySelector, EqualityComparer<V>.Default)
      { }

      public bool Equals(T x, T y)
      {
          return comparer.Equals(keySelector(x), keySelector(y));
      }

      public int GetHashCode(T obj)
      {
          return comparer.GetHashCode(keySelector(obj));
      }
    }
    /// <summary>
    /// 比较器
    /// </summary>
    public static class DistinctExtensions
    {
        public static IEnumerable<T> Distinct<T, V>(this IEnumerable<T> source, Func<T, V> keySelector)
        {
            return source.Distinct(new CommonEqualityComparer<T, V>(keySelector));
        }

        public static IEnumerable<T> Distinct<T, V>(this IEnumerable<T> source, Func<T, V> keySelector, IEqualityComparer<V> comparer)
        {
            return source.Distinct(new CommonEqualityComparer<T, V>(keySelector, comparer));
        }
    }
}
