﻿using System.Collections.Generic;
using System.Text;

/****************************************************************
*   作者：tianzh
*   创建时间：2017/3/9 13:47:22
*   描述说明：
*
*   修改历史：
*
*
*****************************************************************/
namespace Bailun.Core.Extension.Json
{
    /// <summary>
    /// 从本地文件读取Json辅助类
    /// </summary>
   public class JsonTxtHelper
    {
        /// <summary>
        /// 从本地读取Json
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="path"></param>
        /// <returns></returns>
        public static List<T> ReadJsonFromTxt<T>(string path) where T : class
        {
           var jsonTxt= System.IO.File.ReadAllText(path, Encoding.UTF8);

           return JsonHelper.FromJsonList<T>(jsonTxt);
        }

        /// <summary>
        /// 从本地读取Json
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="path"></param>
        /// <returns></returns>
        public static T ReadFromTxt<T>(string path) where T : class
        {
            var jsonTxt = System.IO.File.ReadAllText(path, Encoding.UTF8);

            return JsonHelper.FromJson<T>(jsonTxt);
        }
    }
}
