﻿using System.Collections.Generic;
using System.Text;
using Abp.Extensions;
using Bailun.Core.Extension.Entity.Tree.Model;

namespace Bailun.Core.Extension.Entity.Tree
{
    /// <summary>
    /// JsEntityHelper
    /// </summary>
   public static class JsEntityHelper
    {
        public static int lft = 1, rgt = 1000000;
        /// <summary>
        /// 转换树形Json
        /// </summary>
        /// <param name="list">数据源</param>
        /// <param name="parentId">父节点</param>
        /// <returns></returns>
        public static string TreeJson(this List<TreeGridEntity> listData, int index, string parentId)
        {
            StringBuilder sb = new StringBuilder();
            var childNodeList = listData.FindAll(t => t.ParentId!=null&& t.ParentId.ToLower() == parentId.ToLower());
            if (childNodeList.Count > 0) { index++; }
            foreach (TreeGridEntity entity in childNodeList)
            {
                string strJson = entity.EntityJson;
                strJson = strJson.Insert(1, "\"level\":" + index + ",");
                strJson = strJson.Insert(1, "\"isLeaf\":" + (entity.HasChildren != true).ToString().ToLower() + ",");
                strJson = strJson.Insert(1, "\"expanded\":" + (entity.Expanded).ToString().ToLower() + ",");
                strJson = strJson.Insert(1, "\"lft\":" + lft++ + ",");
                strJson = strJson.Insert(1, "\"rgt\":" + rgt-- + ",");
                sb.Append(strJson);
                sb.Append(TreeJson(listData, index, entity.Id));
            }
            return sb.ToString().Replace("}{", "},{");
        }
        /// <summary>
        /// 转换树形Json
        /// </summary>
        /// <param name="list">数据源</param>
        /// <returns></returns>
        public static string TreeGridJson(this List<TreeGridEntity> listData)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("{ \"rows\": [");
            sb.Append(TreeJson(listData, -1, "0"));
            sb.Append("]}");
            return sb.ToString();
        }
        /// <summary>
        /// 转换树Json
        /// </summary>
        /// <param name="list">数据源</param>
        /// <param name="parentId">父节点</param>
        /// <returns></returns>
        public static string TreeToJson(this List<TreeEntity> list, string parentId = "0")
        {
            StringBuilder strJson = new StringBuilder();
            List<TreeEntity> item = list.FindAll(t =>t.ParentId!=null&&t.ParentId.ToLower() == parentId.ToLower());
            strJson.Append("[");
            if (item.Count > 0)
            {
                foreach (TreeEntity entity in item)
                {
                    strJson.Append("{");
                    strJson.Append("\"id\":\"" + entity.Id.ToLower() + "\",");
                    if (!entity.Text.IsNullOrEmpty()) {
                        strJson.Append("\"text\":\"" + entity.Text.Replace("&nbsp;", "") + "\",");
                    }
                    else
                    {
                        strJson.Append("\"text\":\"\",");
                    }
                    strJson.Append("\"value\":\"" + entity.Value + "\",");
                    if (entity.Attribute != null && !string.IsNullOrEmpty(entity.Attribute))
                    {
                        strJson.Append("\"" + entity.Attribute + "\":\"" + entity.AttributeValue + "\",");
                    }
                 
                    if (entity.Title != null && !string.IsNullOrEmpty(entity.Title.Replace("&nbsp;", "")))
                    {
                        strJson.Append("\"title\":\"" + entity.Title.Replace("&nbsp;", "") + "\",");
                    }
                    if (entity.Img != null && !string.IsNullOrEmpty(entity.Img.Replace("&nbsp;", "")))
                    {
                        strJson.Append("\"img\":\"" + entity.Img.Replace("&nbsp;", "") + "\",");
                    }
                    if (entity.CheckState != null)
                    {
                        strJson.Append("\"checkstate\":" + entity.CheckState + ",");
                    }
                    if (entity.ParentId != null)
                    {
                        strJson.Append("\"parentnodes\":\"" + entity.ParentId.ToLower() + "\",");
                    }
                    if (entity.Level != null)
                    {
                        strJson.Append("\"Level\":" + entity.Level + ",");
                    }
                    strJson.Append("\"showcheck\":" + entity.ShowCheck.ToString().ToLower() + ",");
                    strJson.Append("\"isexpand\":" + entity.IsExpand.ToString().ToLower() + ",");
                    if (entity.Complete == true)
                    {
                        strJson.Append("\"complete\":" + entity.Complete.ToString().ToLower() + ",");
                    }
                    strJson.Append("\"hasChildren\":" + entity.HasChildren.ToString().ToLower() + ",");
                    strJson.Append("\"ChildNodes\":" + TreeToJson(list, entity.Id) + "");
                    strJson.Append("},");
                }
                strJson = strJson.Remove(strJson.Length - 1, 1);
            }
            strJson.Append("]");
            return strJson.ToString();
        }


        /// <summary>
        /// ebay类目转换树Json
        /// </summary>
        /// <param name="list">数据源</param>
        /// <param name="parentId">父节点</param>
        /// <returns></returns>
        public static string EbayCatetoryTreeToJson(this List<TreeEntity> list, string parentId = "0")
        {
            StringBuilder strJson = new StringBuilder();
            var item = new List<TreeEntity>();
            if (parentId == "0")
            {
                item = list.FindAll(t => t.ParentId != null && t.ParentId == t.Id);
            }
            else
            {
                item = list.FindAll(t => t.ParentId != t.Id && t.ParentId == parentId);
            }
            
            strJson.Append("[");
            if (item.Count > 0)
            {
                foreach (TreeEntity entity in item)
                {
                    strJson.Append("{");
                    strJson.Append("\"id\":\"" + entity.Id.ToLower() + "\",");
                    if (!entity.Text.IsNullOrEmpty())
                    {
                        strJson.Append("\"text\":\"" + entity.Text.Replace("&nbsp;", "") + "\",");
                    }
                    else
                    {
                        strJson.Append("\"text\":\"\",");
                    }
                    strJson.Append("\"value\":\"" + entity.Value + "\",");
                    if (entity.Attribute != null && !string.IsNullOrEmpty(entity.Attribute))
                    {
                        strJson.Append("\"" + entity.Attribute + "\":\"" + entity.AttributeValue + "\",");
                    }

                    if (entity.Title != null && !string.IsNullOrEmpty(entity.Title.Replace("&nbsp;", "")))
                    {
                        strJson.Append("\"title\":\"" + entity.Title.Replace("&nbsp;", "") + "\",");
                    }
                    if (entity.Img != null && !string.IsNullOrEmpty(entity.Img.Replace("&nbsp;", "")))
                    {
                        strJson.Append("\"img\":\"" + entity.Img.Replace("&nbsp;", "") + "\",");
                    }
                    if (entity.CheckState != null)
                    {
                        strJson.Append("\"checkstate\":" + entity.CheckState + ",");
                    }
                    if (entity.ParentId != null)
                    {
                        strJson.Append("\"parentnodes\":\"" + entity.ParentId.ToLower() + "\",");
                    }
                    if (entity.Level != null)
                    {
                        strJson.Append("\"Level\":" + entity.Level + ",");
                    }
                    strJson.Append("\"showcheck\":" + entity.ShowCheck.ToString().ToLower() + ",");
                    strJson.Append("\"isexpand\":" + entity.IsExpand.ToString().ToLower() + ",");
                    if (entity.Complete == true)
                    {
                        strJson.Append("\"complete\":" + entity.Complete.ToString().ToLower() + ",");
                    }
                    strJson.Append("\"hasChildren\":" + entity.HasChildren.ToString().ToLower() + ",");
                    strJson.Append("\"ChildNodes\":" + EbayCatetoryTreeToJson(list, entity.Id) + "");
                    strJson.Append("},");
                }
                strJson = strJson.Remove(strJson.Length - 1, 1);
            }
            strJson.Append("]");
            return strJson.ToString();
        }
    }
}
