﻿using Abp.Domain.Entities;
using Abp.EntityFrameworkCore;
using Bailun.Core.Extension.Domain;

namespace Bailun.Core.EntityFrameworkCore.EntityFrameworkCore.Repositories
{
    /// <summary>
    /// Base class for custom repositories of the application.
    /// </summary>
    /// <typeparam name="TEntity">Entity type</typeparam>
    /// <typeparam name="TPrimaryKey">Primary key type of the entity</typeparam>
    public abstract class RepositoryBase<TEntity, TPrimaryKey> : RepositoryExtensions<BaseDbContext, TEntity, TPrimaryKey>
        where TEntity : class, IEntity<TPrimaryKey>,new()
    {
        protected RepositoryBase(IDbContextProvider<BaseDbContext> dbContextProvider)
            : base(dbContextProvider)
        {
        }

        // Add your common methods for all repositories
    }

    /// <summary>
    /// Base class for custom repositories of the application.
    /// This is a shortcut of <see cref="RepositoryBase{TEntity,TPrimaryKey}"/> for <see cref="int"/> primary key.
    /// </summary>
    /// <typeparam name="TEntity">Entity type</typeparam>
    public abstract class RepositoryBase<TEntity> : RepositoryBase<TEntity, int>, IRepositoryExtension<TEntity>
        where TEntity : class, IEntity<int>,new()
    {
        protected RepositoryBase(IDbContextProvider<BaseDbContext> dbContextProvider)
            : base(dbContextProvider)
        {
        }

        // Do not add any method here, add to the class above (since this inherits it)!!!
    }
}
