﻿using Abp.EntityFrameworkCore;
using Abp.Modules;
using Abp.Reflection.Extensions;
using Bailun.Core.Core;

namespace Bailun.Core.EntityFrameworkCore.EntityFrameworkCore
{
    [DependsOn(
        typeof(BaseCoreModule),typeof(AbpEntityFrameworkCoreModule))]
    public class BaseEntityFrameworkModule : AbpModule
    {
        /* Used it tests to skip dbcontext registration, in order to use in-memory database of EF Core */
        public bool SkipDbContextRegistration { get; set; }

        public bool SkipDbSeed { get; set; }

        public override void PreInitialize()
        {
        }

        public override void Initialize()
        {
            IocManager.RegisterAssemblyByConvention(typeof(BaseEntityFrameworkModule).GetAssembly());
        }

        public override void PostInitialize()
        {
            
        }
    }
}
