﻿using System;
using Abp.Domain.Entities;
using Abp.EntityFrameworkCore;
using Abp.Events.Bus.Entities;
using Abp.Extensions;
using Abp.Runtime.Session;
using Bailun.Core.Extension.Runtime;
using Bailun.Core.Extension.Utils;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.ChangeTracking;

namespace Bailun.Core.EntityFrameworkCore.EntityFrameworkCore
{
    public class BaseDbContext : AbpDbContext
    {
        /* Define a DbSet for each entity of the application */
        
        public BaseDbContext(DbContextOptions<BaseDbContext> options)
            : base(options)
        {
        }

        

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {

            modelBuilder.Entity<AliexpressCategory>(pc => pc.ToTable("t_aliexpress_category").HasKey(k => k.Id));
            modelBuilder.Entity<AliexpressAttribute>(pc => pc.ToTable("t_aliexpress_attribute").HasKey(k => k.Id));
            modelBuilder.Entity<AliexpressPublishTemplate>(pc => pc.ToTable("t_bi_aliexpress_publish_template").HasKey(k => k.Id));
            modelBuilder.Entity<CategoryMap>(pc => pc.ToTable("t_aliexpress_categorymap").HasKey(k => k.Id));
            base.OnModelCreating(modelBuilder);
        }

        protected override EntityChangeReport ApplyAbpConcepts()
        {
            foreach (var entry in ChangeTracker.Entries())
            {
                switch (entry.State)
                {
                    case EntityState.Added:
                        SetCreationAuditProperties(entry);
                        break;
                    case EntityState.Modified:
                        SetModificationAuditProperties(entry);
                        if (entry.Entity is ISoftDelete && entry.Entity.As<ISoftDelete>().IsDeleted)
                        {
                            SetDeletionAuditProperties(entry.Entity);
                        }

                        break;
                    case EntityState.Unchanged:
                        if (IsSomeFieldModified(entry))
                        {
                            SetModificationAuditProperties(entry);
                            if (entry.Entity is ISoftDelete && entry.Entity.As<ISoftDelete>().IsDeleted)
                            {
                                SetDeletionAuditProperties(entry.Entity);
                            }
                        }
                        break;
                }
            }
            return base.ApplyAbpConcepts();
        }
        private bool IsSomeFieldModified(EntityEntry entry)
        {
            var properties = entry.OriginalValues.Properties;
            foreach (var propertyInfo in properties)
            {
                if (entry.Property(propertyInfo.Name).IsModified)
                    return true;
            }
            return false;
        }
        protected virtual void SetCreationAuditProperties(EntityEntry entry)
        {
            var userId = AbpSession.GetUid();
            var userName = AbpSession.GetUserName() ?? "";

            //Todo:暂时未兼容apb默认字段
          //  SetPropertyValue(entry.Entity, "CreatorUserId", userId.ToStr());

           // SetPropertyValue(entry.Entity, "CreationTime", Clock.Now);

            SetPropertyValue(entry.Entity, "CreateUserName", userName);
        }

        protected virtual void SetDeletionAuditProperties(object entity)
        {
            var userId = AbpSession.GetUserId();
            var userName = AbpSession.GetUserName() ?? "";
            //Todo:暂时未兼容apb默认字段
          //  SetPropertyValue(entity, "DeletionTime", Clock.Now);

            SetPropertyValue(entity, "DeleteUserName", userName);

           // SetPropertyValue(entity, "DeleterUserId", userId.ToStr());
        }


        public void SetPropertyValue(object targetObj, string propertyName, object objValue, bool isCoverValue = false)
        {
            var entityType = targetObj.GetType();
            if (!objValue.IsNullOrEmpty())
            {
                var createNameProperty = entityType.GetProperty(propertyName);
                if (createNameProperty != null)
                {
                    var createNamePropertyValue = createNameProperty.GetValue(targetObj);
                    //如果覆盖值，直接赋值
                    if (isCoverValue)
                    {
                        createNameProperty.SetValue(targetObj, objValue);
                    }
                    else
                    {
                        //不是覆盖值（一般是已经给字段赋值了，不想在这里被覆盖）
                        if (PropertyValueIsNull(createNamePropertyValue))
                        {
                            createNameProperty.SetValue(targetObj, objValue);
                        }
                    }
                }
            }
        }

        private bool PropertyValueIsNull(object propertyValue)
        {
            if (propertyValue == null) return true;
            var typeName = propertyValue.GetType().Name.ToUpper();
            switch (typeName)
            {
                case "DATETIME":
                    return propertyValue.ToString() == DateTime.MinValue.ToStr();
                case "INT32":
                case "INT64":
                    return propertyValue.ToInt32() == 0;
                case "STRING":
                    return propertyValue.IsNullOrEmpty();
                default:
                    return propertyValue.IsNullOrEmpty();
            }
        }

        protected virtual void SetModificationAuditProperties(EntityEntry entry)
        {
            var userId = AbpSession.GetUid();
            var userName = AbpSession.GetUserName() ?? "";
           // SetPropertyValue(entry.Entity, "LastModificationTime", Clock.Now, true);
            SetPropertyValue(entry.Entity, "LastModifierUserName", userName, true);
           // SetPropertyValue(entry.Entity, "LastModifierUserId", userId.ToStr(), true);
        }
    }
}
