﻿using Abp.Modules;
using Abp.Reflection.Extensions;
using Bailun.Core.Core.Localization;

namespace Bailun.Core.Core
{
    public class BaseCoreModule : AbpModule
    {
        public override void PreInitialize()
        {
            Configuration.Auditing.IsEnabledForAnonymousUsers = true;


            ProductLocalizationConfigurer.Configure(Configuration.Localization);

            // Enable this line to create a multi-tenant application.
          //  Configuration.MultiTenancy.IsEnabled = DistributionListingConsts.MultiTenancyEnabled;
            
            
        }

        public override void Initialize()
        {
            IocManager.RegisterAssemblyByConvention(typeof(BaseCoreModule).GetAssembly());
        }

        public override void PostInitialize()
        {
        }
    }
}
