﻿using Abp.Modules;
using Abp.Reflection.Extensions;
using Bailun.Core.Service.Core;
using Bailun.Core.Service.Core.Configuration;
using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Configuration;

namespace Bailun.Core.ApiGateway.Startup
{
    [DependsOn(
      typeof(ProductWebCoreModule))]
    public class ApiGatewayModule : AbpModule
    {
        private readonly IHostingEnvironment _env;
        private readonly IConfigurationRoot _appConfiguration;

        public ApiGatewayModule(IHostingEnvironment env)
        {
            _env = env;
            _appConfiguration = env.GetConfiguration();
        }

        public override void Initialize()
        {
            IocManager.RegisterAssemblyByConvention(typeof(ApiGatewayModule).GetAssembly());
        }
    }
}
