﻿using System;
using System.Collections.Generic;
using System.Net.Http;
using System.Net.Http.Headers;
using System.Text;
using System.Threading.Tasks;

namespace Common.Http
{
    public class HttpClientService
    {
        /// <summary>
        /// Json Post方法
        /// </summary>
        /// <param name="url"></param>
        /// <param name="jsonData"></param>
        /// <returns></returns>
        public static async Task<string> PostJsonAsync(string url, string jsonData, int timeout = 100)
        {
            var httpClient = new HttpClient { Timeout = TimeSpan.FromSeconds(timeout) };
            HttpContent httpContent = new StringContent(jsonData);
            httpContent.Headers.ContentType = new MediaTypeHeaderValue("application/json");
            var response = await httpClient.PostAsync(url, httpContent);
            return await response.Content.ReadAsStringAsync();
        }
    }
}
