﻿using EasyNetQ.AutoSubscribe;
using Microsoft.AspNetCore.Builder;
using Microsoft.Extensions.DependencyInjection;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace TakeStock.API.Extensions
{
    public class EasyNetQMessageDispatcher : IAutoSubscriberMessageDispatcher
    {
        private readonly IServiceProvider services;

        public EasyNetQMessageDispatcher(IServiceProvider services)
        {
            this.services = services;
        }

        void IAutoSubscriberMessageDispatcher.Dispatch<TMessage, TConsumer>(TMessage message)
        {
            var consumer = services.GetService<TConsumer>();
            try
            {
                consumer.Consume(message);
            }
            finally
            {
                //services.Release(consumer);
            }
        }

        Task IAutoSubscriberMessageDispatcher.DispatchAsync<TMessage, TConsumer>(TMessage message)
        {
            var consumer = services.GetService<TConsumer>();
            return consumer.ConsumeAsync(message);
        }
    }
}
