﻿using SqlSugar;
using System;

namespace Domain.TakeStock
{
    public class FullAuditedEntity
    {
        /// <summary>
        /// 创建人Id
        /// </summary>
        public int CreatorUserId { get; set; }

        /// <summary>
        /// 创建人姓名
        /// </summary>
        public string CreateUserName { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreationTime { get; set; }

        /// <summary>
        /// 最后修改时间
        /// </summary>
        [SugarColumn(IsNullable = true)]
        public DateTime? LastModificationTime { get; set; }

        /// <summary>
        /// 最后修改人id
        /// </summary>
        [SugarColumn(IsNullable = true)]
        public int? LastModifierUserId { get; set; }

        /// <summary>
        /// 删除时间
        /// </summary>
        [SugarColumn(IsNullable = true)]
        public DateTime? DeletionTime { get; set; }

        /// <summary>
        /// 删除用户Id
        /// </summary>
        [SugarColumn(IsNullable = true)]
        public int? DeleterUserId { get; set; }

        /// <summary>
        /// 是否删除
        /// </summary>
        public bool IsDeleted { get; set; }
    }
}
