﻿using SqlSugar;
using System;

namespace Domain.TakeStock
{
    /// <summary>
    /// 审核日志
    /// </summary>
    [SugarTable("audit_process_log")]
    public class AuditProcessLog: FullAuditedEntity
    {
        /// <summary>
        /// 审核日志Id
        /// </summary>
        [SugarColumn(IsPrimaryKey = true, IsIdentity = true)]
        public int Id { get; set; }

        /// <summary>
        /// 模板id
        /// </summary>
        public int TemplateId { get; set; }

        /// <summary>
        /// 关系数据Id 盘点计划id
        /// </summary>
        public int RelationDataId { get; set; }

        /// <summary>
        /// 审核顺序
        /// </summary>
        public int AuditSequence { get; set; }

        /// <summary>
        /// 审核用户Id
        /// </summary>
        public int AuditUserId { get; set; }

        /// <summary>
        /// 审核用户名
        /// </summary>
        public string AuditUserName { get; set; }

        /// <summary>
        /// 审核时间
        /// </summary>
        public DateTime? AuditDateTime { get; set; }

        /// <summary>
        /// 审核状态(0-待审核, 1 -审核通过,-1 驳回)
        /// </summary>
        public AuditStatusEnum AuditStatus { get; set; }

        /// <summary>
        /// 审核说明
        /// </summary>
        public string AuditExplain { get; set; }     
    }
}
