﻿using EPPlus.Core.Extensions;
using OfficeOpenXml;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;

namespace Common.Helper
{
    public class EPPlusUtils
    {
        public static ICollection<T> Import<T>(string fileName) where T : class, new()
        {
            FileInfo file = new FileInfo(fileName);
            try
            {
                using (ExcelPackage package = new ExcelPackage(file))
                {
                    return package.GetWorksheet(0).ToList<T>();
                }
            }
            catch (Exception ex)
            {
                return null;
            }
        }
        public static ICollection<T> Import<T>(Stream stream) where T : class, new()
        {
            try
            {
                using (ExcelPackage package = new ExcelPackage(stream))
                {
                    //return package.GetWorksheet(0).ToList<T>();
                    var top = package.GetWorksheet(0).ToList<T>();
                    return top;
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        public static MemoryStream ExportStream(IEnumerable<object> data)
        {
            MemoryStream ms = new MemoryStream();
            using (ExcelPackage package = new ExcelPackage())
            {
                ExcelWorksheet sheet = package.Workbook.Worksheets.Add("sheet1");
                var properties = data?.First().GetType().GetProperties();

                for (int c = 0; c < properties.Count(); c++)
                {
                    int r = 0;
                    foreach (var item in data)
                    {
                        var prop = properties[c];
                        if (r == 0)
                            sheet.Cells[1, c + 1].Value = prop.Name;
                        sheet.Cells[r + 2, c + 1].Value = item.GetType().GetProperty(prop.Name).GetValue(item, null);
                        r++;
                    }
                }
                package.SaveAs(ms);
                ms.Seek(0, SeekOrigin.Begin);
            }

            return ms;
        }



        public static MemoryStream ExportStream<T>(IEnumerable<T> data)
        {
            MemoryStream ms = new MemoryStream();
            using (ExcelPackage package = new ExcelPackage())
            {
                ExcelWorksheet sheet = package.Workbook.Worksheets.Add("sheet1");
                var properties = data?.First().GetType().GetProperties();

                for (int c = 0; c < properties.Count(); c++)
                {
                    int r = 0;
                    foreach (var item in data)
                    {
                        var prop = properties[c];
                        if (r == 0)
                            sheet.Cells[1, c + 1].Value = prop.Name;
                        sheet.Cells[r + 2, c + 1].Value = item.GetType().GetProperty(prop.Name).GetValue(item, null);
                        r++;
                    }
                }
                package.SaveAs(ms);
                ms.Seek(0, SeekOrigin.Begin);
            }

            return ms;
        }

        public static MemoryStream ExportStream(IEnumerable<object> data, Dictionary<string, string> titles, List<ExeclFilterColumnModel> execlFilters = null)
        {
            MemoryStream ms = new MemoryStream();
            using (ExcelPackage package = new ExcelPackage())
            {
                ExcelWorksheet sheet = package.Workbook.Worksheets.Add("sheet1");
                var properties = data.First().GetType().GetProperties();

                for (int c = 0; c < properties.Count(); c++)
                {
                    int r = 0;
                    foreach (var item in data)
                    {
                        var prop = properties[c];

                        if (r == 0)
                            sheet.Cells[1, c + 1].Value = titles.SingleOrDefault(t => t.Key.Equals(prop.Name)).Value;
                        sheet.Cells[r + 2, c + 1].Value = item.GetType().GetProperty(prop.Name).GetValue(item, null);
                        r++;
                    }

                    //sheet.Column(c+1).AutoFit();
                }


                // 将需要的列导出，不需要的列移除
                if (execlFilters != null && execlFilters.Count > 0)
                {
                    string[] remArr = execlFilters.Where(t => t.Check == false).Select(t => t.Column).ToArray();
                    foreach (var item in remArr)
                    {
                        sheet.DeleteColumns(item);
                    }
                }

                package.SaveAs(ms);
                ms.Seek(0, SeekOrigin.Begin);
            }

            return ms;
        }

        /// <summary>
        /// 保存到磁盘
        /// </summary>
        /// <param name="bytes">字节数组</param>
        /// <param name="saveFullPath">全路径</param>
        /// <returns></returns>
        public static bool SaveToDisk(byte[] bytes, string saveFullPath)
        {
            var fullPath = Path.GetDirectoryName(saveFullPath);
            //如果没有此文件夹，则新建
            if (!Directory.Exists(fullPath))
            {
                Directory.CreateDirectory(fullPath);
            }
            //创建文件，返回一个 FileStream，它提供对 path 中指定的文件的读/写访问。
            using (FileStream stream = File.Create(saveFullPath))
            {
                //将字节数组写入流
                stream.Write(bytes, 0, bytes.Length);
                stream.Close();
            }
            return true;
        }
    }

    public class ExeclFilterColumnModel
    {
        public string Column { get; set; }
        public bool Check { get; set; }
    }
}
