﻿using SqlSugar;
using System;
using System.Collections.Generic;
using System.Text;
using static Domain.TakeStock.TakeStockEnum;

namespace Domain.TakeStock
{
    [SugarTable("stock_takestockorder")]
    public class TakeStockOrder
    {
        public TakeStockOrder()
        {
            this.Code = "TSO" + DateTime.Now.ToString("yyMMddHHmmssfff");
            this.CreationTime = DateTime.UtcNow.AddHours(8);
        }

        [SugarColumn(IsPrimaryKey = true, IsIdentity = true)]
        public int Id { get; set; }
        
        /// <summary>
        /// 盘点单号
        /// </summary>
        [SugarColumn(Length = 50)]
        public string Code { get; set; }

        public int ScheduleId { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        [SugarColumn(Length = 20)]
        public string WarehouseCode { get; set; }

        public TSOrderState State { get; set; }

        /// <summary>
        /// 产品sku
        /// </summary>
        [SugarColumn(Length = 50)]
        public string Sku { get; set; }

        /// <summary>
        /// 盘点前数量
        /// </summary>
        [SugarColumn(IsNullable = true)]
        public int? BeforeQuantity { get; set; }

        /// <summary>
        /// 盘点后数量
        /// </summary>
        [SugarColumn(IsNullable = true)]
        public int? AfterQuantity { get; set; }

        /// <summary>
        /// 等待完结的配货单号
        /// </summary>
        [SugarColumn(IsNullable = true, Length = 1000)]
        public string WaitCodes { get; set; }

        /// <summary>
        /// 取消的配货单号
        /// </summary>
        [SugarColumn(IsNullable = true, Length = 1000)]
        public string CancelCodes { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        [SugarColumn(IsNullable = true, Length = 500)]
        public string Description { get; set; }

        public DateTime CreationTime { get; set; }

        [SugarColumn(IsNullable = true)]
        public long? CreatorUserId { get; set; }

        [SugarColumn(IsNullable = true)]
        public DateTime? LastModificationTime { get; set; }

        [SugarColumn(IsNullable = true)]
        public long? LastModifierUserId { get; set; }

        public bool IsDeleted { get; set; }

        [SugarColumn(IsNullable = true)]
        public long? DeleterUserId { get; set; }

        [SugarColumn(IsNullable = true)]
        public DateTime? DeletionTime { get; set; }
    }
}
