using Hangfire;
using Hangfire.MySql;
using IService.TakeStock;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Service.TakeStock;
using System;
using System.Transactions;

namespace TakeStock.Web
{
    public class Startup
    {
        public Startup(IConfiguration configuration)
        {
            Configuration = configuration;
        }

        public IConfiguration Configuration { get; }

        // This method gets called by the runtime. Use this method to add services to the container.
        public void ConfigureServices(IServiceCollection services)
        {
            services.Configure<CookiePolicyOptions>(options =>
            {
                // This lambda determines whether user consent for non-essential cookies is needed for a given request.
                options.CheckConsentNeeded = context => true;
                options.MinimumSameSitePolicy = SameSiteMode.None;
            });

            RegisterHttpClient(services);

            //services.AddScoped<RabbitMQClient>();
            services.AddScoped<ITakeStockService, TakeStockService>();

            // Add Hangfire services.
            services.AddHangfire(configuration => configuration
                .SetDataCompatibilityLevel(CompatibilityLevel.Version_170)
                .UseSimpleAssemblyNameTypeSerializer()
                .UseRecommendedSerializerSettings()
                .UseStorage(new MySqlStorage(
                    Configuration["ConnectionStrings:Localhost"],
                    new MySqlStorageOptions
                    {
                        TransactionIsolationLevel = IsolationLevel.ReadCommitted,
                        QueuePollInterval = TimeSpan.FromSeconds(15),
                        JobExpirationCheckInterval = TimeSpan.FromHours(1),
                        CountersAggregateInterval = TimeSpan.FromMinutes(5),
                        PrepareSchemaIfNecessary = true,
                        DashboardJobListLimit = 50000,
                        TransactionTimeout = TimeSpan.FromMinutes(1),
                        TablesPrefix = "Hangfire_"
                    })
                )
            );

            // Add the processing server as IHostedService
            services.AddHangfireServer();


            services.AddMvc().SetCompatibilityVersion(CompatibilityVersion.Version_2_2);
        }

        // This method gets called by the runtime. Use this method to configure the HTTP request pipeline.
        public void Configure(IApplicationBuilder app, IHostingEnvironment env)
        {
            //new DbContext().Migration();

            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }
            else
            {
                app.UseExceptionHandler("/Error");
            }

            app.UseStaticFiles();
            app.UseCookiePolicy();

            app.UseHangfireDashboard();

            app.UseMvc();
        }

        public void RegisterHttpClient(IServiceCollection services)
        {
            string node = "WMS";
            services.AddHttpClient(Configuration[$"{ node }:Name"], c =>
            {
                Setting(node, c); //WMS_QueryStockPoolWMS_QueryStockPool
            });
        }

        public void Setting(string node, System.Net.Http.HttpClient client)
        {
            client.Timeout = TimeSpan.FromSeconds(Convert.ToDouble(Configuration[$"{ node }:Timeout"]));
            client.BaseAddress = new Uri(Configuration[$"{ node }:Uri"]);
        }
    }
}
