﻿using Domain.Domain.TakeStock;
using Domain.Domain.TakeStock.Repository;
using SqlSugar;
using System;
using System.Collections.Generic;

namespace TakeStock.SqlSugar.Repository.TakeStock
{
    public class TakeStockScheduleRepository : Repository<TakeStockSchedule>, ITakeStockScheduleRepository
    {
        public TakeStockScheduleRepository(DbContext dbContext) : base(dbContext)
        {
        }

        public bool CreateOrder(TakeStockSchedule schedule, List<TakeStockOrder> orders)
        {
            try
            {                
                client.Ado.BeginTran();
                int scheduleId = InsertAndGetId(schedule);
                for (int i = 0; i < orders.Count; i++)
                {
                    var order = orders[i]; 
                    order.ScheduleId = scheduleId;
                    order = client.Insertable(order).ExecuteReturnEntity();                    
                }                
                client.Ado.CommitTran();
                return true;
            }
            catch (Exception ex)
            {
                client.Ado.RollbackTran();
                return false;
            }
        }
    }
}
