﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Domain.TakeStock
{
    public class Stock
    {
        /// <summary>
        /// 产品SKU
        /// </summary>
        public virtual string Sku { get; set; }

        /// <summary>
        /// 平台SKU
        /// </summary>
        public virtual string PlatSKU { get; set; }

        /// <summary>
        /// sku标题
        /// </summary>
        public virtual string Title { get; set; }

        /// <summary>
        /// sku英文标题
        /// </summary>
        public virtual string EnTitle { get; set; }

        /// <summary>
        /// 仓编码
        /// </summary>
        public virtual string WarehouseCode { get; set; }
        
        /// <summary>
        /// 待上架库存
        /// </summary> 
        public virtual int PendingStock { get; set; }

        /// <summary>
        /// 在途库存
        /// </summary> 
        public virtual int InboundStock { get; set; }

        /// <summary>
        /// 占用库存
        /// </summary> 
        public virtual int ReserveStock { get; set; }

        /// <summary>
        /// 可用库存
        /// </summary> 
        public virtual int AvailabelStock { get; set; }

        /// <summary>
        /// 不可用库存
        /// </summary> 
        public virtual int UnSellStock { get; set; }

        /// <summary>
        /// 已发货库存
        /// </summary> 
        public virtual int ShippedStock { get; set; }

        /// <summary>
        /// 同步时间
        /// </summary> 
        public virtual DateTime? SyncTime { get; set; }

        /// <summary>
        /// 可用状态
        /// </summary>
        public int State { get; set; }
    }
}
