﻿using System;
using System.Collections.Generic;
using System.Text;
using static Domain.Domain.TakeStock.TakeStockEnum;

namespace TakeStock.Application.TakeStock.Dto
{
    public class ScheduleInputDto
    {
        /// <summary>
        /// 盘点单号
        /// </summary>
        public string Code { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string WarehouseCode { get; set; }

        /// <summary>
        /// 盘点人Id
        /// </summary>
        public int ExecutorId { get; set; }

        /// <summary>
        /// 系统自动盘点
        /// </summary>
        public bool IsAutomation { get; set; }

        /// <summary>
        /// 状态
        /// </summary>
        public TSScheduleState State { get; set; }

        /// <summary>
        /// 描述
        /// </summary>
        public string Description { get; set; }

        public DateTime CreationTime { get; set; }

        public long? CreatorUserId { get; set; }

        public DateTime? LastModificationTime { get; set; }

        public long? LastModifierUserId { get; set; }

        public bool IsDeleted { get; set; }

        public long? DeleterUserId { get; set; }

        public DateTime? DeletionTime { get; set; }

        public virtual List<OrderInputDto> Orders { get; set; }
    }
}
