﻿using System;
using System.Collections.Generic;
using System.Text;
using static Domain.Domain.TakeStock.TakeStockEnum;

namespace TakeStock.Application.TakeStock.Dto
{
    public class OrderInputDto
    {
        /// <summary>
        /// 盘点单号
        /// </summary>
        public string Code { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string WarehouseCode { get; set; }

        public TSOrderState State { get; set; }

        /// <summary>
        /// 产品sku
        /// </summary>
        public string Sku { get; set; }

        /// <summary>
        /// 盘点前数量
        /// </summary>
        public int? BeforeQuantity { get; set; }

        /// <summary>
        /// 盘点后数量
        /// </summary>
        public int? AfterQuantity { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string Description { get; set; }

        public DateTime CreationTime { get; set; }

        public long? CreatorUserId { get; set; }

        public DateTime? LastModificationTime { get; set; }

        public long? LastModifierUserId { get; set; }
    }
}
