﻿using SqlSugar;
using System;
using System.Collections.Generic;
using System.Text;
using static Domain.Domain.TakeStock.TakeStockEnum;

namespace Domain.Domain.TakeStock
{
    [SugarTable("stock_takestockschedule")]
    public class TakeStockSchedule
    {
        [SugarColumn(IsPrimaryKey = true, IsIdentity = true)]
        public int Id { get; set; }

        /// <summary>
        /// 盘点单号
        /// </summary>
        [SugarColumn(Length = 50)]
        public string Code { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        [SugarColumn(Length = 20)]
        public string WarehouseCode { get; set; }
        
        /// <summary>
        /// 盘点人Id
        /// </summary>
        public int ExecutorId { get; set; }
        
        /// <summary>
        /// 系统自动盘点
        /// </summary>
        public bool IsAutomation { get; set; }

        /// <summary>
        /// 状态
        /// </summary>
        public TSScheduleState State { get; set; }

        /// <summary>
        /// 描述
        /// </summary>
        [SugarColumn(IsNullable = true, Length = 500)]
        public string Description { get; set; }

        [SugarColumn(IsOnlyIgnoreInsert = true)]
        public DateTime CreationTime { get; set; }

        [SugarColumn(IsNullable = true)]
        public long? CreatorUserId { get; set; }

        [SugarColumn(IsNullable = true)]
        public DateTime? LastModificationTime { get; set; }

        [SugarColumn(IsNullable = true)]
        public long? LastModifierUserId { get; set; }

        public bool IsDeleted { get; set; }

        [SugarColumn(IsNullable = true)]
        public long? DeleterUserId { get; set; }

        [SugarColumn(IsNullable = true)]
        public DateTime? DeletionTime { get; set; }

        //public virtual List<TakeStockOrder> Orders { get; set; }
    }
}
