﻿using SqlSugar;
using System;
using System.Collections.Generic;
using System.Text;
using static Domain.Domain.TakeStock.TakeStockEnum;

namespace Domain.Domain.TakeStock
{
    [SugarTable("stock_takestockorder_log")]
    public class TakeStockOrderLog
    {
        public TakeStockOrderLog()
        {
            this.CreationTime = DateTime.Now;
        }

        [SugarColumn(IsPrimaryKey = true, IsIdentity = true)]
        public int Id { get; set; }

        public int OrderId { get; set; }

        public TSOrderState State { get; set; }

        [SugarColumn(Length = 500)]
        public string Content { get; set; }

        [SugarColumn(IsNullable = true, Length = 2000)]
        public string JsonData { get; set; }

        public DateTime CreationTime { get; set; }

        public long? CreatorUserId { get; set; }

        public DateTime? LastModificationTime { get; set; }

        public long? LastModifierUserId { get; set; }
    }
}
