﻿using Domain.Domain;
using Domain.Domain.TakeStock;
using Microsoft.Extensions.Configuration;

namespace SqlSugar
{
    public class DbContext
    {
        public IConfiguration Configuration { get; }
        public SqlSugarClient Db;
        public DbContext(IConfiguration configuration)
        {
            Configuration = configuration;

            if (Db == null)
                Db = new SqlSugarClient(new ConnectionConfig()
            {
                ConnectionString = Configuration["ConnectionStrings:Localhost"],
                DbType = DbType.MySql,
                IsAutoCloseConnection = true,
                InitKeyType = InitKeyType.Attribute,
                //AopEvents = new AopEvents()
                //{
                //    OnLogExecuting = (sql, p) =>
                //    {
                //        Console.WriteLine(sql);
                //    }
                //}
            });
            //Db.CodeFirst.BackupTable().InitTables(typeof(CheckRecord));
            //Db.CodeFirst.SetStringDefaultLength(10).InitTables(typeof(Stock));
        }

        public SqlSugarClient GetInstance()
        {
            Db = new SqlSugarClient(new ConnectionConfig()
            {
                ConnectionString = Configuration["ConnectionStrings:Localhost"],
                DbType = DbType.MySql,
                IsAutoCloseConnection = true,
                InitKeyType = InitKeyType.Attribute,
                //AopEvents = new AopEvents()
                //{
                //    OnLogExecuting = (sql, p) =>
                //    {
                //        Console.WriteLine(sql);
                //    }
                //}
            });

            ////Print sql
            //db.Aop.OnLogExecuting = (sql, pars) =>
            //{
            //    Console.WriteLine(sql + "\r\n" + db.Utilities.SerializeObject(pars.ToDictionary(it => it.ParameterName, it => it.Value)));
            //    Console.WriteLine();
            //};
            return Db;
        }

        public void Migration()
        {
            //Db.CodeFirst.SetStringDefaultLength(20/*设置varchar默认长度为200*/)
            //    .InitTables(typeof(TakeStockSchedule), typeof(TakeStockOrder), typeof(TakeStockOrderLog));//执行完数据库就有这个表了
        }
    }
}