﻿using Domain.Domain.TakeStock;
using IService.TakeStock;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using TakeStock.Application.TakeStock.Dto;

namespace TakeStock.Application.TakeStock
{
    public class TakeStockAppService
    {
        private readonly ITakeStockService takeStockService;

        public TakeStockAppService(ITakeStockService takeStockService)
        {
            this.takeStockService = takeStockService;
        }

        public async Task<bool> CreateCheckRecord(ScheduleInputDto input)
        {
            var str = JsonConvert.SerializeObject(input);
            TakeStockSchedule schedule = JsonConvert.DeserializeObject<TakeStockSchedule>(str);
            List<TakeStockOrder> orders = JObject.Parse(str)["Orders"].ToObject<List<TakeStockOrder>>();
            return await takeStockService.CreateTakeStockOrderAsync(schedule, orders);
        }

        public async Task<bool> StartTakeStock(StartTakeStockInputDto input)
        {
            return await takeStockService.StartTakeStock(input.Id, input.BeforeQuantity);
        }

        public async Task<bool> Feedback(FeedbackInputDto input)
        {
            return await takeStockService.Feedback(input.Id, input.AfterQuantity);
        }
    }
}
