﻿using Domain.Domain.TakeStock;
using IService.TakeStock;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using TakeStock.Application.TakeStock.Dto;

namespace TakeStock.Application.TakeStock
{
    public class TakeStockAppService
    {
        private readonly ITakeStockService takeStockService;

        public TakeStockAppService(ITakeStockService takeStockService)
        {
            this.takeStockService = takeStockService;
        }

        public async Task<bool> CreateCheckRecord(CheckRecordInputDto input)
        {
            var str = JsonConvert.SerializeObject(input);
            CheckRecord record = JsonConvert.DeserializeObject<CheckRecord>(str);
            return await takeStockService.CreateCheckRecordAsync(record);
        }

        public async Task<bool> FreezeStockAsync(int id)
        {
            return await takeStockService.FreezeStockAsync(id);
        }

        public async Task<bool> RollbackStockAsync(int id)
        {
            return await takeStockService.RollbackStockAsync(id);
        }
    }
}
