﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using IService.TakeStock;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Service.TakeStock;
using TakeStock.Application.TakeStock;
using TakeStock.Application.TakeStock.Dto;

namespace TakeStock.API.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class TakeStockController : ControllerBase
    {
        private readonly TakeStockAppService takeStockAppService;

        public TakeStockController(TakeStockAppService takeStockAppService)
        {
            this.takeStockAppService = takeStockAppService;
        }

        // GET: api/TakeStock
        [HttpGet]
        public IEnumerable<string> Get()
        {
            return new string[] { "value1", "value2" };
        }

        // GET: api/TakeStock/5
        [HttpGet("{id}", Name = "Get")]
        public string Get(int id)
        {
            return "value";
        }

        // POST: api/TakeStock
        //[HttpPost]
        //public void Post([FromBody] string value)
        //{
        //}

        [HttpPost]
        public async Task<bool> PostCheckRecord([FromBody] CheckRecordInputDto record)
        {
            var result = await takeStockAppService.CreateCheckRecord(record);
            return result;
        }

        // PUT: api/TakeStock/5
        [HttpPut("{id}")]
        public void Put(int id)
        {
            //queryStockPoolService.AcquireStockPool().Wait();
            //takeStockAppService.FreezeStockAsync(id).Wait();
            takeStockAppService.RollbackStockAsync(id).Wait();
        }

        // DELETE: api/ApiWithActions/5
        [HttpDelete("{id}")]
        public void Delete(int id)
        {
        }
    }
}
