﻿using Domain.Domain.TakeStock;
using System.Collections.Generic;
using System.Threading.Tasks;

namespace IService.TakeStock
{
    public interface ITakeStockService
    {
        /// <summary>
        /// 创建盘点记录
        /// </summary>
        /// <param name="record"></param>
        /// <returns></returns>
        Task<bool> CreateTakeStockOrderAsync(TakeStockSchedule record, List<TakeStockOrder> orders);

        Task<bool> ReTry(int scheduleId);

        /// <summary>
        /// 发起线下盘点
        /// </summary>
        /// <param name="order"></param>
        /// <returns></returns>
        Task<bool> StartTakeStock(int id, int beforeQuantity);

        /// <summary>
        /// 盘点结果反馈
        /// </summary>
        /// <param name="order"></param>
        /// <returns></returns>
        Task<bool> Feedback(int id, int afterQuantity, string description);

        /// <summary>
        /// 取消盘点的订单
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        Task<bool> CancelOrder(int id);

        ///// <summary>
        ///// 冻结库存
        ///// </summary>
        ///// <param name="id"></param>
        ///// <returns></returns>
        //Task<bool> FreezeStockAsync(int id);

        ///// <summary>
        ///// 回滚库存
        ///// </summary>
        ///// <param name="warehouseCode"></param>
        ///// <param name="sku"></param>
        ///// <returns></returns>
        //Task<bool> RollbackStockAsync(int id);

        ///// <summary>
        ///// 同步和启用库存
        ///// </summary>
        ///// <param name="warehouseCode"></param>
        ///// <param name="sku"></param>
        ///// <returns></returns>
        //Task<bool> SyncAndEnabledAsync(int id);
    }
}
