﻿using Domain.TakeStock;
using System;
using Common.Extensions;
using static Domain.TakeStock.TakeStockEnum;

namespace TakeStock.Application.TakeStock.Dto
{
    /// <summary>
    /// 导出盘点数据
    /// </summary>
    public class ExportTakeStockOutputDto
    {
        /// <summary>
        /// sku
        /// </summary>
        public string Sku { get; set; }

        /// <summary>
        /// 盘点前数量
        /// </summary>
        public int BeforeQuantity { get; set; }

        /// <summary>
        /// 盘点后数量
        /// </summary>
        public int AfterQuantity { get; set; }

        /// <summary>
        /// 计划单号
        /// </summary>
        public string Code { get; set; }

        /// <summary>
        /// 审核人姓名
        /// </summary>
        public string AuditUserName { get; set; }

        /// <summary>
        /// 审核时间
        /// </summary>
        public string AuditDateTime { get; set; }

        /// <summary>
        /// 审核说明
        /// </summary>
        public string AuditExplain { get; set; }

        /// <summary>
        /// 仓库名称
        /// </summary>
        public string WarehouseName { get; set; }

        /// <summary>
        /// 盘点说明
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// 盘点类型
        /// </summary>
        public int TakeStockType { get; set; }

        public string TakeStockTypeStr => ((TakeStockType)TakeStockType).GetEnumDes();

        /// <summary>
        /// 盘点计划时间
        /// </summary>
        public string CreationTime { get; set; }


        /// <summary>
        /// 附件下载地址
        /// </summary>
        public string CredentialsImgUrl { get; set; }

        /// <summary>
        /// 盘点状态
        /// </summary>
        public int State { get; set; }

        public string StateStr => ((TSScheduleState)State).GetEnumDes();

        /// <summary>
        /// 盘点人姓名
        /// </summary>
        public string CreatorUserName { get; set; }

        /// <summary>
        /// 流水单号
        /// </summary>
        public string SysSerialNumber { get; set; }

        /// <summary>
        /// 盘亏类型
        /// </summary>
        public int? InventoryLossType { get; set; }

        public string InventoryLossTypeStr => InventoryLossType.HasValue ? ((InventoryLossType)InventoryLossType).GetEnumDes() : string.Empty;
    }
}
