﻿using Domain.TakeStock;
using Domain.TakeStock.Repository;
using SqlSugar;
using System;
using System.Collections.Generic;
using static Domain.TakeStock.TakeStockEnum;

namespace TakeStock.SqlSugar.Repository.TakeStock
{
    public class TakeStockScheduleRepository : Repository<TakeStockSchedule>, ITakeStockScheduleRepository
    {
        public TakeStockScheduleRepository(DbContext dbContext) : base(dbContext)
        {
        }

        public int CreateOrder(TakeStockSchedule schedule, List<TakeStockOrder> orders)
        {
            try
            {                
                client.Ado.BeginTran();
                int scheduleId = InsertAndGetId(schedule);
                for (int i = 0; i < orders.Count; i++)
                {
                    var order = orders[i]; 
                    order.ScheduleId = scheduleId;
                    order = client.Insertable(order).ExecuteReturnEntity();    
                    
                }                
                client.Ado.CommitTran();
                return scheduleId;
            }
            catch (Exception ex)
            {
                client.Ado.RollbackTran();
                return 0;
            }
        }

        public int CreateOrderAndFreezeStock(TakeStockSchedule schedule, List<TakeStockOrder> orders)
        {
            try
            {
                client.Ado.BeginTran();
                int scheduleId = InsertAndGetId(schedule);
                for (int i = 0; i < orders.Count; i++)
                {
                    var order = orders[i];
                    order.ScheduleId = scheduleId;
                    order = client.Insertable(order).ExecuteReturnEntity();
                    var log = new TakeStockOrderLog { OrderId = order.Id, State = TSOrderState.冻结库存, Content = "冻结库存成功。" , CreationTime =DateTime.Now};
                    client.Insertable(log);
                }
                client.Ado.CommitTran();
                return scheduleId;
            }
            catch (Exception ex)
            {
                client.Ado.RollbackTran();
                return 0;
            }
        }
    }
}
