﻿using Common.Extensions;
using Domain.TakeStock;
using System;

namespace TakeStock.Application.TakeStock.Dto
{
    public class ScheduleOutputDto
    {
        public int Id { get; set; }

        /// <summary>
        /// 盘点单号
        /// </summary>
        public string Code { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string WarehouseCode { get; set; }

        /// <summary>
        /// 盘点人Id
        /// </summary>
        public int ExecutorId { get; set; }

        /// <summary>
        /// 系统自动盘点
        /// </summary>
        public bool IsAutomation { get; set; }

        /// <summary>
        /// 状态
        /// </summary>
        public string State { get; set; }

        /// <summary>
        /// 描述
        /// </summary>
        public string Description { get; set; }

        public DateTime CreationTime { get; set; }

        public long? CreatorUserId { get; set; }

        public string CreatorUserName { get; set; }

        public DateTime? LastModificationTime { get; set; }

        public string LastModifierUserName { get; set; }

        public long? LastModifierUserId { get; set; }

        public bool IsDeleted { get; set; }

        public long? DeleterUserId { get; set; }

        public DateTime? DeletionTime { get; set; }

        /// <summary>
        /// 系统交易流水号
        /// </summary>
        public string SysSerialNumber { get; set; }

        /// <summary>
        /// 审核人id
        /// </summary>
        public int? AuditUserId { get; set; }

        /// <summary>
        /// 审核人姓名
        /// </summary>
        public string AuditUserName { get; set; }
        /// <summary>
        /// 审核时间
        /// </summary>
        public DateTime? AuditDateTime { get; set; }

        /// <summary>
        /// 审核时间
        /// </summary>
        public string AuditDateTimeStr => AuditDateTime.HasValue ? AuditDateTime.Value.ToLongStr() : string.Empty;

        /// <summary>
        /// 审核说明
        /// </summary>
        public string AuditExplain { get; set; }

        /// <summary>
        /// 盘点类型
        /// </summary>
        public TakeStockType TakeStockType { get; set; }

        /// <summary>
        /// 盘点类型
        /// </summary>
        public string TakeStockTypeStr => TakeStockType.GetEnumDes();

        /// <summary>
        /// 凭证照片地址
        /// </summary>
        public string CredentialsImgUrl { get; set; }

        /// <summary>
        /// 盘亏类型
        /// </summary>
        public InventoryLossType? InventoryLossType { get; set; }

        public string InventoryLossTypeStr => InventoryLossType.HasValue ? InventoryLossType.Value.GetEnumDes() : string.Empty;

        /// <summary>
        /// 退货单类型
        /// </summary>
        public ReturnOrderNoType? ReturnOrderNoType { get; set; }

        public string ReturnOrderNoTypeStr => ReturnOrderNoType.HasValue ? ReturnOrderNoType.Value.GetEnumDes() : string.Empty;
        /// <summary>
        /// 退货单号
        /// </summary>
        public string ReturnOrderNo { get; set; }
    }
}
