﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using Common.Helper;
using Domain.Dto;
using Domain.TakeStock;
using IService.TakeStock;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Service.TakeStock;
using TakeStock.Application.TakeStock;
using TakeStock.Application.TakeStock.Dto;

namespace TakeStock.API.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class TakeStockController : ControllerBase
    {
        private readonly TakeStockAppService takeStockAppService;

        public TakeStockController(TakeStockAppService takeStockAppService)
        {
            this.takeStockAppService = takeStockAppService;
        }

        // GET: api/TakeStock
        [HttpGet]
        public IEnumerable<string> Get()
        {
            //takeStockAppService.PushTakeStockMsg();
            return new string[] { "value1", "value2" };
        }

        // GET: api/TakeStock/5
        [HttpGet("{id}", Name = "Get")]
        public string Get(int id)
        {
            return "value";
        }

        // POST: api/TakeStock
        //[HttpPost]
        //public void Post([FromBody] string value)
        //{
        //}

        [HttpPost]
        public async Task<ReturnPlanDto> CreateTakeStockSchedule([FromBody] ScheduleInputDto record)
        {
            var result = await takeStockAppService.CreateTakeStockSchedule(record);
            return result;
        }

        [HttpPost("StartTakeStock")]
        public async Task<bool> StartTakeStock([FromBody] StartTakeStockInputDto input)
        {
            return await takeStockAppService.StartTakeStock(input);
        }

        [HttpPost("CanceledInform")]
        public async Task<bool> CanceledInform([FromBody] CanceledInformInputDto input)
        {
            return await takeStockAppService.CanceledInform(input.Id, input.ACOrderCode);
        }

        [HttpPost("DeliveryInform")]
        public async Task<bool> DeliveryInform([FromBody] DeliveryInformInputDto input)
        {
            return await takeStockAppService.DeliveryInform(input.Id, input.ACOrderCode);
        }

        [HttpGet("ReTry")]
        public async Task<bool> ReTry(int scheduleId)
        {
            return await takeStockAppService.ReTry(scheduleId);
        }

        [HttpPost("Feedback")]
        public async Task<bool> Feedback([FromBody] FeedbackInputDto input)
        {
            return await takeStockAppService.Feedback(input);
        }

        [HttpPost("SaveDescription")]
        public async Task<bool> SaveDescription([FromBody] FeedbackInputDto input)
        {
            return await takeStockAppService.SaveDescription(input);
        }

        [HttpGet("CancelOrder")]
        public async Task<bool> CancelOrder(int id)
        {
            return await takeStockAppService.CancelOrder(id);
        }

        // DELETE: api/ApiWithActions/5
        [HttpDelete("{id}")]
        public void Delete(int id)
        {
        }

        [HttpPost("GetScheduleByPage")]
        public async Task<SearchScheduleByPageOutputDto> GetScheduleByPage([FromBody] SearchScheduleByPageInputDto input)
        {
            return await takeStockAppService.SearchScheduleByPage(input);
        }

        [HttpPost("GetOrderByPage")]
        public async Task<SearchOrderByPageOutputDto> GetOrderByPage([FromBody] SearchOrderByPageInputDto input)
        {
            return await takeStockAppService.SearchOrderByPage(input);
        }

        [HttpGet("GetOrderLogs")]
        public async Task<List<LogOutputDto>> GetOrderLogs(int id)
        {
            return await takeStockAppService.SearchOrderLogs(id);
        }

        /// <summary>
        /// 上传照片凭据
        /// </summary>
        /// <param name="file"></param>
        /// <returns></returns>
        [HttpPost("UploadCredentials")]
        public async Task<string> UploadCredentials(IFormFile file)
        {
            var fileExtension = Path.GetExtension(file.FileName);
            var stream = file.OpenReadStream();
            byte[] bytes = new byte[stream.Length];
            stream.Read(bytes, 0, bytes.Length);
            stream.Seek(0, SeekOrigin.Begin);
            string fileName = Guid.NewGuid().ToString("N") + fileExtension;
            var result = await new QiNiuCloudUtils().UploadStreamAsync(fileName, bytes);
            return result.Code == 200 ? $"http://omsimg.blsct.com/{fileName}" : string.Empty;
        }

        /// <summary>
        /// 审核计划单
        /// </summary>
        /// <param name="inputDto"></param>
        /// <returns></returns>
        [HttpPost("AuditTakeStockSchedule")]
        public async Task<ReturnPlanDto> AuditTakeStockSchedule([FromBody] AuditTakeStockScheduleInputDto inputDto)
        {
            return await takeStockAppService.AuditTakeStockSchedule(inputDto);
        }

        /// <summary>
        /// 取消盘点计划单
        /// </summary>
        /// <param name="scheduleIds"></param>
        /// <returns></returns>
        [HttpPost("CancelTakeStockSchedule")]
        public async Task<ReturnPlanDto> CancelTakeStockSchedule(CancelTakeStockScheduleInPutDto input)
        {
            return await takeStockAppService.CancelTakeStockSchedule(input);
        }
    }
}
