﻿using Domain.TakeStock;
using EasyNetQ.AutoSubscribe;
using IService.TakeStock;
using Message.TakeStock;
using System;
using System.Collections.Generic;
using System.Threading.Tasks;

namespace Service.TakeStock
{
    public class CreateTakeStockConsumer : IConsumeAsync<CreateTakeStockMessage>
    {
        private readonly ITakeStockService _takeStockService;

        public CreateTakeStockConsumer(ITakeStockService takeStockService)
        {
            this._takeStockService = takeStockService;
        }

        [AutoSubscriberConsumer(SubscriptionId = "CreateTakeStock")]
        public async Task ConsumeAsync(CreateTakeStockMessage message)
        {
            TakeStockSchedule schedule = new TakeStockSchedule()
            {
                WarehouseCode = message.WarehouseCode,
                IsAutomation = true,
                Description = "库存不足发起的系统自动盘点。",
                CreationTime = DateTime.Now
        };

            List<TakeStockOrder> orders = new List<TakeStockOrder>()
            {
                new TakeStockOrder
                {
                    Sku = message.Sku,
                    CreationTime = DateTime.Now
                }
            };
            await _takeStockService.CreateTakeStockOrderAsync(schedule, orders);
        }
    }
}
