﻿using EasyNetQ;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace MessageQueue
{
    public class RabbitMQClient
    {
        public RabbitMQClient()
        {
            this.connectionStr = "host=127.0.0.1:5672;username=guest;password=guest;prefetchcount=2;publisherConfirms=true;timeout=10";
            this.bus = RabbitHutch.CreateBus(connectionStr);
        }

        private readonly string connectionStr;
        private readonly IBus bus;

        public async Task<bool> SendAsync<T>(string queueName, T t) where T: class
        {
            bus.Publish(t);
            var task = bus.SendAsync(queueName, t);
            return task.IsCompleted;
        }
    }
}
