﻿using Microsoft.Extensions.Configuration;
using Qiniu.Http;
using Qiniu.Storage;
using Qiniu.Util;
using System.IO;
using System.Threading.Tasks;

namespace Common.Helper
{
    public class QiNiuCloudUtils
    {
        private readonly IConfigurationRoot configuration;
        private readonly string AccessKey = string.Empty;
        public readonly string SecretKey = string.Empty;
        public readonly string _cdnUrl = string.Empty;

        public QiNiuCloudUtils()
        {
            configuration = Configurations.Get(DirectoryFinder.CalculateContentRootFolder());
            AccessKey = configuration["QiNiu:AccessKey"];
            SecretKey = configuration["QiNiu:SecretKey"];
            _cdnUrl = configuration["QiNiu:cdnUrl"];
        }

        public string cdnUrl
        {
            get
            {
                return _cdnUrl;
            }
        }


        /// <summary>
        /// 刊登cdn地址
        /// </summary>
        //public static readonly string PublishListingCdnUrl = ConfigManagerConf.GetValue("QiNiu:PublishListingCdnUrl");
        /// <summary>
        /// 七牛存储节点
        /// </summary>
        private static readonly string Bucket = "bailun-oms";

        #region 上传文件
        /// <summary>
        /// 上传文件
        /// </summary>
        /// <param name="saveFile"></param>
        /// <param name="content"></param>
        /// <returns></returns>
        public async Task<HttpResult> UploadStreamAsync(string saveFile, byte[] content)
        {
            Mac mac = new Mac(AccessKey, SecretKey);

            // 设置上传策略，详见：https://developer.qiniu.com/kodo/manual/1206/put-policy
            PutPolicy putPolicy = new PutPolicy();
            putPolicy.Scope = Bucket + ":" + saveFile;  //覆盖式更新

            // putPolicy.SetExpires(3600);
            string token = Auth.CreateUploadToken(mac, putPolicy.ToJsonString());
            Qiniu.Storage.Config config = new Qiniu.Storage.Config();
            // 设置上传区域
            config.Zone = Zone.ZoneCnSouth;
            // 设置 http 或者 https 上传
            //config.UseHttps = true;
            //config.UseCdnDomains = true;
            //config.ChunkSize = ChunkUnit.U512K;
            FormUploader target = new FormUploader(config);
            var result = await target.UploadStream(new MemoryStream(content), saveFile, token, null);

            //result.code==200 上传成功
            return result;

        }
        #endregion

        public async Task<HttpResult> UploadBigStreamAsync(string saveFile, string localFile, string mimeType = "")
        {
            Mac mac = new Mac(AccessKey, SecretKey);

            // 设置上传策略，详见：https://developer.qiniu.com/kodo/manual/1206/put-policy
            PutPolicy putPolicy = new PutPolicy();
            putPolicy.Scope = Bucket + ":" + saveFile;  //覆盖式更新
            if (!string.IsNullOrEmpty(mimeType))
            {
                putPolicy.MimeLimit = mimeType;

            }
            // putPolicy.SetExpires(3600);
            string token = Auth.CreateUploadToken(mac, putPolicy.ToJsonString());
            Config config = new Config
            {
                Zone = Zone.ZoneCnSouth,
                ChunkSize = ChunkUnit.U1024K
            };
            // 包含两个参数，并且都有默认值
            // 参数1(bool): uploadFromCDN是否从CDN加速上传，默认否
            // 参数2(enum): chunkUnit上传分片大小，可选值128KB,256KB,512KB,1024KB,2048KB,4096KB
            ResumableUploader ru = new ResumableUploader(config);
            UploadProgressHandler upph = new UploadProgressHandler(ResumableUploader.DefaultUploadProgressHandler);
            var putExtra = new PutExtra
            {
                ProgressHandler = upph,
                MaxRetryTimes = 10,
            };
            // ResumableUploader.UploadFile有多种形式，您可以根据需要来选择
            //
            // 最简模式，使用默认recordFile和默认uploadProgressHandler
            // UploadFile(localFile,saveKey,token)
            // 
            // 基本模式，使用默认uploadProgressHandler
            // UploadFile(localFile,saveKey,token,recordFile)
            //
            // 一般模式，使用自定义进度处理(可以监视上传进度)
            // UploadFile(localFile,saveKey,token,recordFile,uploadProgressHandler)
            //
            // 高级模式，包含上传控制(可控制暂停/继续 或者强制终止)
            // UploadFile(localFile,saveKey,token,recordFile,uploadProgressHandler,uploadController)
            // 
            // 支持自定义参数
            //var extra = new System.Collections.Generic.Dictionary<string, string>();
            //extra.Add("FileType", "UploadFromLocal");
            //extra.Add("YourKey", "YourValue");
            //uploadFile(...,extra,...)
            //UploadController upctl = new UploadController();
            var result = await ru.UploadFile(localFile, saveFile, token, putExtra);

            return result;
        }

    }
}
