﻿using Domain.TakeStock;
using System;
using System.Collections.Generic;
using System.Text;
using static Domain.TakeStock.TakeStockEnum;

namespace TakeStock.Application.TakeStock.Dto
{
    public class ScheduleInputDto
    {
        /// <summary>
        /// 仓库编码
        /// </summary>
        public string WarehouseCode { get; set; }

        /// <summary>
        /// 盘点人Id
        /// </summary>
        public int ExecutorId { get; set; }

        /// <summary>
        /// 系统自动盘点
        /// </summary>
        public bool IsAutomation { get; set; }

        /// <summary>
        /// 描述
        /// </summary>
        public string Description { get; set; }

        public long? CreatorUserId { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string CreatorUserName { get; set; }

        public virtual List<OrderInputDto> Orders { get; set; }

        /// <summary>
        /// 盘点类型
        /// </summary>
        public TakeStockType TakeStockType { get; set; }

        /// <summary>
        /// 盘亏类型
        /// </summary>
        public InventoryLossType? InventoryLossType { get; set; }

        /// <summary>
        /// 退货类型
        /// </summary>
        public ReturnGoodsType? ReturnGoodsType { get; set; }

        /// <summary>
        /// 凭证照片地址
        /// </summary>
        public string CredentialsImgUrl { get; set; }
        /// <summary>
        /// 退货单类型
        /// </summary>
        public ReturnOrderNoType? ReturnOrderNoType { get; set; }

        /// <summary>
        /// 退货单号
        /// </summary>
        public string ReturnOrderNo { get; set; }

        /// <summary>
        /// sku总金额
        /// </summary>
        public decimal SkuTotalAmount { get; set; }

        /// <summary>
        /// 租户Id
        /// </summary>
        public int TenantId { get; set; }
    }
}
