﻿using EasyNetQ;
using EasyNetQ.Topology;
using Message.TakeStock;
using Microsoft.Extensions.DependencyInjection;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Net.Http;
using System.Net.Http.Headers;
using System.Text;
using System.Threading.Tasks;

namespace TakeStock.Subscriber
{
    class Program
    {
        static void Main(string[] args)
        {
            try
            {
                Init();
                //111.230.164.154 owms-rabbitmq
                var connStr = "host=owms-rabbitmq:5672;username=bailun;password=1234abcd;prefetchcount=2;publisherConfirms=true;timeout=10"; 
                var bus = RabbitHutch.CreateBus(connStr);
                bus.SubscribeAsync<CreateTakeStockMessage>("Create", async message => await Exec(message)
                .ContinueWith(task =>
                {
                    if (task.IsCompleted && !task.IsFaulted)
                    {
                        bool isSuccess = task.Result;
                    }
                    else
                    {
                        Console.WriteLine(message.ToString());
                        Console.WriteLine("Message processing exception - look in the default error queue (broker)");
                        throw new EasyNetQException("Message processing exception - look in the default error queue (broker)");
                    }
                }));
                               
                //CreateTakeStockMessage msg = new CreateTakeStockMessage
                //{
                //    WarehouseCode = "BLTEST",
                //    Sku = "TEST0004"
                //};

                //MessageProperties messageProperties = new MessageProperties();
                //messageProperties.Type = "TakeStock.Create";
                
                //var advancedBus = bus.Advanced;
                //var queue = advancedBus.QueueDeclare("TakeStock_Create");
                //var exchange = advancedBus.ExchangeDeclare("TakeStock", ExchangeType.Topic);
                //var binding = advancedBus.Bind(exchange, queue, "TakeStock_Create");

                //byte[] message = Encoding.UTF8.GetBytes(JsonConvert.SerializeObject(msg));
                //advancedBus.Publish(exchange, "TakeStock_Create", false, messageProperties, message);
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
            }
        }

        private static IServiceCollection services;
        private static IServiceProvider serviceProvider;

        private static void Init()
        {
            services = new ServiceCollection();
            //注入
            //services.AddTransient<ILoggerFactory, LoggerFactory>();
            services.AddHttpClient("TakeStock", c =>
            {
                c.Timeout = TimeSpan.FromSeconds(30);
                //193.112.230.53
                c.BaseAddress = new Uri("http://wms-takestock-api:5002/api/");
            });

            serviceProvider = services.BuildServiceProvider();
        }

        private static async Task<bool> Exec(CreateTakeStockMessage message)
        {
            IHttpClientFactory _httpClientFactory = serviceProvider.GetService<IHttpClientFactory>();

            var schedule = new
            {
                WarehouseCode = message.WarehouseCode,
                IsAutomation = true,
                Description = "库存不足发起的系统自动盘点。",
                CreationTime = DateTime.Now,
                Orders = new List<dynamic>()
                {
                    new
                    {
                        WarehouseCode = message.WarehouseCode,
                        Sku = message.Sku,
                        //CreationTime = TSOrderState
                    }
                }
            };

            var client = _httpClientFactory.CreateClient("TakeStock");
            HttpContent content = new StringContent(JsonConvert.SerializeObject(schedule));
            content.Headers.ContentType = new MediaTypeHeaderValue("application/json");
            var response = await client.PostAsync("TakeStock", content);

            bool isSuccess = false;
            if (response.IsSuccessStatusCode)
            {
                var responseContent = await response.Content.ReadAsStringAsync();
                isSuccess = Convert.ToBoolean(responseContent);
            }

            return isSuccess;
        }
    }
}
