﻿using SqlSugar;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using static Domain.TakeStock.TakeStockEnum;

namespace Domain.TakeStock
{
    [SugarTable("stock_takestockschedule")]
    public class TakeStockSchedule
    {
        public TakeStockSchedule()
        {
            this.Code = "TSS" + DateTime.Now.ToString("yyMMddHHmmssfff");
            this.CreationTime = DateTime.Now;
        }

        [SugarColumn(IsPrimaryKey = true, IsIdentity = true)]
        public int Id { get; set; }

        /// <summary>
        /// 盘点单号
        /// </summary>
        [SugarColumn(Length = 50)]
        public string Code { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        [SugarColumn(Length = 20)]
        public string WarehouseCode { get; set; }

        /// <summary>
        /// 盘点人Id
        /// </summary>
        public int ExecutorId { get; set; }

        /// <summary>
        /// 系统自动盘点
        /// </summary>
        public bool IsAutomation { get; set; }

        /// <summary>
        /// 状态
        /// </summary>
        public TSScheduleState State { get; set; }

        /// <summary>
        /// 描述
        /// </summary>
        [SugarColumn(IsNullable = true, Length = 500)]
        public string Description { get; set; }

        public DateTime CreationTime { get; set; }

        [SugarColumn(IsNullable = true)]
        public long? CreatorUserId { get; set; }

        [SugarColumn(IsNullable = true)]
        public DateTime? LastModificationTime { get; set; }

        [SugarColumn(IsNullable = true)]
        public long? LastModifierUserId { get; set; }

        public bool IsDeleted { get; set; }

        [SugarColumn(IsNullable = true)]
        public long? DeleterUserId { get; set; }

        [SugarColumn(IsNullable = true)]
        public DateTime? DeletionTime { get; set; }

        //public virtual List<TakeStockOrder> Orders { get; set; }

        [SugarColumn(IsNullable = true)]
        public string CreatorUserName { get; set; }

        [SugarColumn(IsNullable = true)]
        public string LastModifierUserName { get; set; }

        /// <summary>
        /// 系统交易流水号
        /// </summary>
        [SugarColumn(IsNullable = true, Length = 45)]
        public string SysSerialNumber { get; set; }

        /// <summary>
        /// 审核人id
        /// </summary>
        public int? AuditUserId { get; set; }

        /// <summary>
        /// 审核人姓名
        /// </summary>
        public string AuditUserName { get; set; }
        /// <summary>
        /// 审核时间
        /// </summary>
        public DateTime? AuditDateTime { get; set; }
        /// <summary>
        /// 审核说明
        /// </summary>
        public string AuditExplain { get; set; }

        /// <summary>
        /// 盘点类型
        /// </summary>
        public TakeStockType TakeStockType { get; set; }
        /// <summary>
        /// 盘亏类型
        /// </summary>
        public InventoryLossType? InventoryLossType { get; set; }

        /// <summary>
        /// 退货类型
        /// </summary>
        public ReturnGoodsType? ReturnGoodsType { get; set; }

        /// <summary>
        /// 凭证照片地址
        /// </summary>
        public string CredentialsImgUrl { get; set; }
        /// <summary>
        /// 退货单类型
        /// </summary>
        public ReturnOrderNoType? ReturnOrderNoType { get; set; }
        /// <summary>
        /// 退货单号
        /// </summary>
        public string ReturnOrderNo { get; set; }

        /// <summary>
        /// sku总金额
        /// </summary>
        public decimal SkuTotalAmount { get; set; }
    }

    /// <summary>
    /// 盘点类型
    /// </summary>
    public enum TakeStockType
    {
        /// <summary>
        /// 默认
        /// </summary>
        [Description("默认")]
        None = 0,
        /// <summary>
        /// 盘亏
        /// </summary>
        [Description("盘亏")]
        InventoryLoss = 1,
        /// <summary>
        /// 盘盈
        /// </summary>
        [Description("盘盈")]
        InventorySurplus = 2,
        /// <summary>
        /// 退货业务
        /// </summary>
        [Description("退货业务")]
        ReturnGoods = 3,
        /// <summary>
        /// 报废
        /// </summary>
        [Description("报废")]
        Voidgoods = 4
    }

    /// <summary>
    /// 盘亏类型
    /// </summary>
    public enum InventoryLossType
    {
        /// <summary>
        /// 默认
        /// </summary>
        [Description("默认")]
        None = 0,
        /// <summary>
        /// 
        /// </summary>
        [Description("丢失")]
        Lose = 1,
        /// <summary>
        /// 报损
        /// </summary>
        [Description("报损")]
        FrmLoss = 2,
        /// <summary>
        /// 违禁品
        /// </summary>
        [Description("违禁品")]
        Contraband = 3
    }

    /// <summary>
    /// 退货类型
    /// </summary>
    public enum ReturnGoodsType
    {

        /// <summary>
        /// 良品
        /// </summary>
        [Description("良品")]
        GoodProduct = 1,
        /// <summary>
        /// 不良品
        /// </summary>
        [Description("不良品")]
        Rejects = 2,
        /// <summary>
        /// 换渠道
        /// </summary>
        [Description("换渠道")]
        ChannelChange = 3
    }

    /// <summary>
    /// 退货单号类型
    /// </summary>
    public enum ReturnOrderNoType
    {
        /// <summary>
        /// 默认
        /// </summary>
        [Description("默认")]
        None = 0,
        [Description("退货单号")]
        AllotOrderCode = 1,

        /// <summary>
        /// OMS配货单号
        /// </summary>
        [Description("OMS配货单号")]
        AcOrderCode = 2,
        /// <summary>
        /// 采购单号
        /// </summary>
        [Description("采购单号")]
        PurchaseOrderCode = 3,
        /// <summary>
        /// 其它单号
        /// </summary>
        [Description("其它单号")]
        Other = 4
    }
}
