﻿using Domain;
using SqlSugar;
using System;
using System.Collections;
using System.Threading.Tasks;

namespace TakeStock.SqlSugar
{
    public class Repository<TEntity> : IRepository<TEntity> where TEntity : class, new()
    {
        protected readonly SqlSugarClient client;

        public Repository(DbContext dbContext)
        {
            this.client = dbContext.Db;
        }

        public int Count()
        {
            throw new NotImplementedException();
        }

        public int Count(System.Linq.Expressions.Expression<Func<TEntity, bool>> predicate)
        {
            return client.Queryable<TEntity>().Count(predicate);
        }

        public Task<int> CountAsync(System.Linq.Expressions.Expression<Func<TEntity, bool>> predicate)
        {
            throw new NotImplementedException();
        }

        public Task<int> CountAsync()
        {
            throw new NotImplementedException();
        }

        public void Delete(TEntity entity)
        {
            throw new NotImplementedException();
        }

        //public void Delete(TPrimaryKey id)
        //{
        //    throw new NotImplementedException();
        //}

        //public void Delete(System.Linq.Expressions.Expression<Func<TEntity, bool>> predicate)
        //{
        //    throw new NotImplementedException();
        //}

        //public Task DeleteAsync(TPrimaryKey id)
        //{
        //    throw new NotImplementedException();
        //}

        //public Task DeleteAsync(System.Linq.Expressions.Expression<Func<TEntity, bool>> predicate)
        //{
        //    throw new NotImplementedException();
        //}

        //public Task DeleteAsync(TEntity entity)
        //{
        //    throw new NotImplementedException();
        //}

        //public TEntity FirstOrDefault(System.Linq.Expressions.Expression<Func<TEntity, bool>> predicate)
        //{
        //    throw new NotImplementedException();
        //}

        //public TEntity FirstOrDefault(TPrimaryKey id)
        //{
        //    throw new NotImplementedException();
        //}

        public Task<TEntity> FirstOrDefaultAsync(System.Linq.Expressions.Expression<Func<TEntity, bool>> predicate)
        {
            return client.Queryable<TEntity>().Where(predicate).FirstAsync();
        }

        //public Task<TEntity> FirstOrDefaultAsync(TPrimaryKey id)
        //{
        //    throw new NotImplementedException();
        //}

        public TEntity Get(int id)
        {
            return client.Queryable<TEntity>().InSingle(id);
        }

        //public IQueryable<TEntity> GetAll()
        //{
        //    throw new NotImplementedException();
        //}

        //public IQueryable<TEntity> GetAllIncluding(params System.Linq.Expressions.Expression<Func<TEntity, object>>[] propertySelectors)
        //{
        //    throw new NotImplementedException();
        //}

        //public List<TEntity> GetAllList(System.Linq.Expressions.Expression<Func<TEntity, bool>> predicate)
        //{
        //    throw new NotImplementedException();
        //}

        //public List<TEntity> GetAllList()
        //{
        //    throw new NotImplementedException();
        //}

        //public Task<List<TEntity>> GetAllListAsync(System.Linq.Expressions.Expression<Func<TEntity, bool>> predicate)
        //{
        //    throw new NotImplementedException();
        //}

        //public Task<List<TEntity>> GetAllListAsync()
        //{
        //    throw new NotImplementedException();
        //}

        //public Task<TEntity> GetAsync(TPrimaryKey id)
        //{
        //    throw new NotImplementedException();
        //}

        public TEntity Insert(TEntity entity)
        {
            throw new NotImplementedException();
        }

        public bool InsertFulfill(TEntity entity)
        {
            return client.Insertable(entity).ExecuteCommand() > 0;
        }

        public int InsertOnTheBatch(params TEntity[] entityes)
        {
            return client.Insertable(entityes).ExecuteCommand();
        }

        public int InsertAndGetId(TEntity entity)
        {
            return client.Insertable(entity).ExecuteReturnIdentity();
        }

        //public Task<TPrimaryKey> InsertAndGetIdAsync(TEntity entity)
        //{
        //    throw new NotImplementedException();
        //}

        public Task<TEntity> InsertAsync(TEntity entity)
        {
            return Task.Run(() =>
            {
                return client.Insertable(entity).ExecuteReturnEntity();
            });
        }

        //public TEntity InsertOrUpdate(TEntity entity)
        //{
        //    throw new NotImplementedException();
        //}

        //public TPrimaryKey InsertOrUpdateAndGetId(TEntity entity)
        //{
        //    throw new NotImplementedException();
        //}

        //public Task<TPrimaryKey> InsertOrUpdateAndGetIdAsync(TEntity entity)
        //{
        //    throw new NotImplementedException();
        //}

        //public Task<TEntity> InsertOrUpdateAsync(TEntity entity)
        //{
        //    throw new NotImplementedException();
        //}

        //public TEntity Load(TPrimaryKey id)
        //{
        //    throw new NotImplementedException();
        //}

        //public long LongCount(System.Linq.Expressions.Expression<Func<TEntity, bool>> predicate)
        //{
        //    throw new NotImplementedException();
        //}

        //public long LongCount()
        //{
        //    throw new NotImplementedException();
        //}

        //public Task<long> LongCountAsync()
        //{
        //    throw new NotImplementedException();
        //}

        //public Task<long> LongCountAsync(System.Linq.Expressions.Expression<Func<TEntity, bool>> predicate)
        //{
        //    throw new NotImplementedException();
        //}

        //public T Query<T>(Func<IQueryable<TEntity>, T> queryMethod)
        //{
        //    throw new NotImplementedException();
        //}

        //public TEntity Single(System.Linq.Expressions.Expression<Func<TEntity, bool>> predicate)
        //{
        //    throw new NotImplementedException();
        //}

        //public Task<TEntity> SingleAsync(System.Linq.Expressions.Expression<Func<TEntity, bool>> predicate)
        //{
        //    throw new NotImplementedException();
        //}

        //public TEntity Update(TEntity entity)
        //{
        //    throw new NotImplementedException();
        //}

        //public TEntity Update(TPrimaryKey id, Action<TEntity> updateAction)
        //{
        //    throw new NotImplementedException();
        //}

        //public Task<TEntity> UpdateAsync(TPrimaryKey id, Func<TEntity, Task> updateAction)
        //{
        //    throw new NotImplementedException();
        //}

        public Task<int> UpdateAsync(TEntity entity, params string[] columns)
        {
            if (columns?.Length > 0)
                return client.Updateable(entity).UpdateColumns(columns).ExecuteCommandAsync();
            else
                return client.Updateable(entity).ExecuteCommandAsync();
        }
    }
}
