﻿using Domain;
using Domain.Domain.TakeStock.Repository;
using Hangfire;
using Hangfire.MySql;
using IService.TakeStock;
using MessageQueue;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.TagHelpers;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Service.TakeStock;
using SqlSugar;
using StackExchange.Redis;
using System;
using System.Linq;
using System.Transactions;
using TakeStock.API.Extensions;
using TakeStock.Application.TakeStock;
using TakeStock.SqlSugar;
using TakeStock.SqlSugar.Repository.TakeStock;

namespace TakeStock.API
{
    public class Startup
    {
        public Startup(IConfiguration configuration)
        {
            Configuration = configuration;
            Redis = ConnectionMultiplexer.Connect(Configuration.GetConnectionString("Redis"));
        }

        public IConfiguration Configuration { get; }
        public static ConnectionMultiplexer Redis;

        // This method gets called by the runtime. Use this method to add services to the container.
        public void ConfigureServices(IServiceCollection services)
        {
            services.AddCors(options =>
            {
                options.AddPolicy("Default", builder =>
                {
                    // App:CorsOrigins in appsettings.json can contain more than one address separated by comma.
                    builder
                        .WithOrigins(Configuration["App:CorsOrigins"].Split(",", StringSplitOptions.RemoveEmptyEntries)
                        //.Select(o => o.RemovePostFix("/"))
                        .ToArray())
                        .AllowAnyHeader()
                        .AllowAnyMethod();
                });
            });

            //var redis = ConnectionMultiplexer.Connect("172.17.0.2:6379");
            //services.AddDataProtection().PersistKeysToStackExchangeRedis(redis, "DataProtection-Keys");

            RegisterHttpClient(services);

            services.AddScoped<RabbitMQClient>();
            services.AddScoped<ITakeStockService, TakeStockService>();
            services.AddScoped<DbContext>();
            services.AddScoped(typeof(IRepository<>), typeof(Repository<>));
            services.AddScoped(typeof(ITakeStockScheduleRepository), typeof(TakeStockScheduleRepository));
            services.AddScoped<TakeStockAppService>();

            services.AddHttpClient();

            // Add Hangfire services.
            services.AddHangfire(configuration => configuration.UseRedisStorage(Redis)
            );

            // Add the processing server as IHostedService
            services.AddHangfireServer();
            services.AddMvc()
                .SetCompatibilityVersion(CompatibilityVersion.Version_2_2);
        }

        // This method gets called by the runtime. Use this method to configure the HTTP request pipeline.
        public void Configure(IApplicationBuilder app, IHostingEnvironment env, DbContext dbContext)
        {
            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }
            var options = new DashboardOptions
            {
                IgnoreAntiforgeryToken = true, 
                Authorization = new[]
                {
                    new CustomAuthorizationFilter()
                }
            };
            app.UseHangfireDashboard("/hangfire", options);

            app.UseMvc();
            dbContext.Migration();
        }

        public void RegisterHttpClient(IServiceCollection services)
        {
            string node = "WMS";
            services.AddHttpClient(Configuration[$"{ node }:Name"], c =>
            {
                Setting(node, c); //WMS_QueryStockPoolWMS_QueryStockPool
            });
        }

        public void Setting(string node, System.Net.Http.HttpClient client)
        {
            client.Timeout = TimeSpan.FromSeconds(Convert.ToDouble(Configuration[$"{ node }:Timeout"]));
            client.BaseAddress = new Uri(Configuration[$"{ node }:Uri"]);
        }
    }
}
