﻿using SqlSugar;
using System;
using System.Collections.Generic;
using System.Text;
using static Domain.Domain.TakeStock.TakeStockEnum;

namespace Domain.Domain.TakeStock
{
    [SugarTable("stock_takestockorder")]
    public class TakeStockOrder
    {
        [SugarColumn(IsPrimaryKey = true, IsIdentity = true)]
        public int Id { get; set; }
        
        /// <summary>
        /// 盘点单号
        /// </summary>
        [SugarColumn(Length = 50)]
        public string Code { get; set; }

        public int ScheduleId { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        [SugarColumn(Length = 20)]
        public string WarehouseCode { get; set; }

        public TSOrderState State { get; set; }

        /// <summary>
        /// 产品sku
        /// </summary>
        [SugarColumn(Length = 50)]
        public string Sku { get; set; }

        /// <summary>
        /// 盘点前数量
        /// </summary>
        [SugarColumn(IsNullable = true)]
        public int? BeforeQuantity { get; set; }

        /// <summary>
        /// 盘点后数量
        /// </summary>
        [SugarColumn(IsNullable = true)]
        public int? AfterQuantity { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        [SugarColumn(IsNullable = true, Length = 500)]
        public string Description { get; set; }

        public DateTime CreationTime { get; set; }

        [SugarColumn(IsNullable = true)]
        public long? CreatorUserId { get; set; }

        [SugarColumn(IsNullable = true)]
        public DateTime? LastModificationTime { get; set; }

        [SugarColumn(IsNullable = true)]
        public long? LastModifierUserId { get; set; }
    }
}
