﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using IService.TakeStock;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Service.TakeStock;
using TakeStock.Application.TakeStock;
using TakeStock.Application.TakeStock.Dto;

namespace TakeStock.API.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class TakeStockController : ControllerBase
    {
        private readonly TakeStockAppService takeStockAppService;

        public TakeStockController(TakeStockAppService takeStockAppService)
        {
            this.takeStockAppService = takeStockAppService;
        }

        // GET: api/TakeStock
        [HttpGet]
        public IEnumerable<string> Get()
        {
            return new string[] { "value1", "value2" };
        }

        // GET: api/TakeStock/5
        [HttpGet("{id}", Name = "Get")]
        public string Get(int id)
        {
            return "value";
        }

        // POST: api/TakeStock
        //[HttpPost]
        //public void Post([FromBody] string value)
        //{
        //}

        [HttpPost]
        public async Task<bool> CreateTakeStockSchedule([FromBody] ScheduleInputDto record)
        {
            var result = await takeStockAppService.CreateTakeStockSchedule(record);
            return result;
        }
        
        [HttpPost("StartTakeStock")]
        public async Task<bool> StartTakeStock([FromBody] StartTakeStockInputDto input)
        {
            return await takeStockAppService.StartTakeStock(input);
        }

        [HttpGet("ReTry")]
        public async Task<bool> ReTry(int scheduleId)
        {
            return await takeStockAppService.ReTry(scheduleId);
        }

        [HttpPost("Feedback")]
        public async Task<bool> Feedback([FromBody] FeedbackInputDto input)
        {
            return await takeStockAppService.Feedback(input);
        }

        [HttpGet("CancelOrder")]
        public async Task<bool> CancelOrder(int id)
        {
            return await takeStockAppService.CancelOrder(id);
        }

        // DELETE: api/ApiWithActions/5
        [HttpDelete("{id}")]
        public void Delete(int id)
        {
        }

        [HttpPost("GetScheduleByPage")]
        public async Task<SearchScheduleByPageOutputDto> GetScheduleByPage([FromBody] SearchScheduleByPageInputDto input)
        {
            return await takeStockAppService.SearchScheduleByPage(input);
        }
    }
}
