﻿using API.Services.PlatDataManageServices;
using ApiControl;
using PetaPoco.Custom.PlatData;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Http;

namespace WebApi.Areas.PlatDataManage.Controllers
{
    [RoutePrefix("api/PlatDataManage")]
    public class PlatFeeController : ApiController
    {
        // GET: PlatDataManage/PlatFee
        /// <summary>
        /// 更新产品状态信息
        /// </summary>
        /// <returns></returns>
        [Route("PlatFeeData")]
        public ApiResult PlatFeeData(DataStr ds)
        {
            ApiResult result = new ApiResult();
            try
            {
                ApiCompare pare = ApiDataManage.GetSignCompare(ds);
                if (pare.state)
                {
                    var objPlatFee = CommonBaseLib.GetJsonToObject<PlatFee>(pare.data.data);
                    result = PlatFeeServices.GetPlatFeeList(objPlatFee.Plat, objPlatFee.Site);
                }
                else
                {
                    result = pare.result;
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg = ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 更新产品状态信息
        /// </summary>
        /// <returns></returns>
        [Route("CategoryPlatFeeList")]
        public ApiResult CategoryPlatFeeList(DataStr ds)
        {
            ApiResult result = new ApiResult();
            try
            {
                ApiCompare pare = ApiDataManage.GetSignCompare(ds);
                if (pare.state)
                {
                    var dataList = CommonBaseLib.GetJsonToObject<List<PrimaryPlatFee>>(pare.data.data);
                    result = PlatFeeServices.GetCategoryPlatFeeList(dataList);
                }
                else
                {
                    result = pare.result;
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg = ex.Message;
            }
            return result;
        }
    }
}