﻿using API.Services;
using API.Services.HqygManageServices;
using ApiControl;
using Bailun.Cache;
using DbConn;
using Petapoco.Custom.HqygDto;
using System;
using System.Threading.Tasks;
using System.Web.Http;

namespace WebApi.Areas.HqygDataManage.Controllers
{
    /// <summary>
    /// Api入口控制中心
    /// </summary>
    [RoutePrefix("api/PdmData")]
    public class PdmDataController : ApiController
    {
        /// <summary>
        /// 获取公共数据入口
        /// </summary>
        /// <returns></returns>
        [Route("GetProductInfo")]
        public ApiResult GetProductInfo(string sign, string appId, string data)
        {
            DataStr ds = new DataStr()
            {
                sign = sign,
                appId = appId,
                data = data
            };
            ApiResult result = new ApiResult();
            try
            {
                ApiCompare pare = ApiDataManage.GetSignCompare(ds);
                if (pare.state)
                {
                    string method = pare.data.data;
                    var resultData = RedisCacheService.GetList<ProductBaseList>(HqygDataServices.GetRedisName(method), method + "_code", () => HqygDataServices.GetProductCommon(method), TimeSpan.FromDays(1));
                    if (resultData.Count > 0)
                    {
                        result.result_code = 1;
                        result.data = CommonBaseLib.EncodeAndJson(resultData);
                    }
                }
                else
                {
                    result = pare.result;
                }
            }
            catch
            {
                result = ApiDataManage.CreateApiResult(500);
            }
            return result;
        }

        /// <summary>
        /// 新增产品信息至环球PDM
        /// </summary>
        /// <returns></returns>
        [Route("ManageProductAdd")]
        public ApiResult ManageProductAdd(DataStr ds)
        {
            ApiResult result = new ApiResult();
            try
            {
                ApiCompare pare = ApiDataManage.GetSignCompare(ds);
                if (pare.state)
                {
                    var modelList = CommonBaseLib.GetJsonToObject<yt_product_base>(pare.data.data);
                    result = PdmDataServices.BindProductAdd(modelList);
                }
                else
                {
                    result = pare.result;
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg = ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 更新产品信息至环球PDM
        /// </summary>
        /// <returns></returns>
        [Route("ManageProductEdit")]
        public ApiResult ManageProductEdit(DataStr ds)
        {
            ApiResult result = ApiAddressCenter.ApiAnalysisCenter(ds);
            //开启自动同步到环球
            //Task.Factory.StartNew(() =>
            //{
            //    PdmDataServices.InsertOrUpdateToSame();
            //});
            return result;
        }
    }
}