﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace PetaPoco.Custom.SkuMap
{
    public class ResultSkuMapInfo
    {
        /// <summary>
        /// 返回数据类型，1正常，2分页，99导出
        /// </summary>
        public int resultType { get; set; }

        /// <summary>
        /// 页数
        /// </summary>
        public int page { get; set; }

        /// <summary>
        /// 分页大小，最大1000
        /// </summary>
        public int pageSize { get; set; }

        /// <summary>
        /// 排序列
        /// </summary>
        public string sortField { get; set; }

        /// <summary>
        /// 排序方式
        /// </summary>
        public string sort { get; set; }

        /// <summary>
        /// 主键
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 平台Id
        /// </summary>
        public int platId { get; set; }

        /// <summary>
        /// 平台
        /// </summary>
        public string plat { get; set; }

        /// <summary>
        /// 站点Id
        /// </summary>
        public int siteId { get; set; }

        /// <summary>
        /// 站点
        /// </summary>
        public string site { get; set; }

        /// <summary>
        /// 帐号Id
        /// </summary>
        public int accountId { get; set; }

        /// <summary>
        /// 登录帐号
        /// </summary>
        public string loginAccount { get; set; }

        /// <summary>
        /// OMS帐号
        /// </summary>
        public string account { get; set; }

        /// <summary>
        /// 销售
        /// </summary>
        public string sellerName { get; set; }

        /// <summary>
        /// 刊登商品编码
        /// </summary>
        public string platProduct { get; set; }

        /// <summary>
        /// ItemId
        /// </summary>
        public string itemId { get; set; }

        /// <summary>
        /// ItemUrl
        /// </summary>
        public string ItemUrl { get; set; }

        /// <summary>
        /// 查询类型 1为模糊查询，其他为精确查询
        /// </summary>
        public int type { get; set; }

        /// <summary>
        /// 查询类型 1 平台SKU 2产品库SKU 3中文名称
        /// </summary>
        public int searchType { get; set; }

        /// <summary>
        /// 查询值
        /// </summary>
        public string search { get; set; }

        /// <summary>
        /// 平台SKU
        /// </summary>
        public string platSku { get; set; }

        /// <summary>
        /// 产品库SKU
        /// </summary>
        public string sku { get; set; }

        /// <summary>
        /// 中文名称
        /// </summary>
        public string title { get; set; }

        /// <summary>
        /// 数量
        /// </summary>
        public int count { get; set; }

        /// <summary>
        /// 内部商品编码
        /// </summary>
        public string goodsCode { get; set; }

        /// <summary>
        /// 内部产品编码
        /// </summary>
        public string productCode { get; set; }

        /// <summary>
        /// 商品表Id
        /// </summary>
        public int mainId { get; set; }

        /// <summary>
        /// skuid
        /// </summary>
        public int sId { get; set; }

        /// <summary>
        /// 商品编码
        /// </summary>
        public string product { get; set; }

        /// <summary>
        /// 组合关系
        /// </summary>
        public string groupRelete { get; set; }

        /// <summary>
        /// 一级分类
        /// </summary>
        public int firCate { get; set; }

        /// <summary>
        /// 二级分类
        /// </summary>
        public int secCate { get; set; }

        /// <summary>
        /// 平台分类全名
        /// </summary>
        public string fullName { get; set; }

        /// <summary>
        /// 属性类型
        /// </summary>
        public string attrType { get; set; }

        /// <summary>
        /// 是否组合
        /// </summary>
        public string isGroup { get; set; }

        /// <summary>
        /// 是否任意SKU
        /// </summary>
        public string isAny { get; set; }

        /// <summary>
        /// 是否映射完成
        /// </summary>
        public string isMap { get; set; }

        /// <summary>
        /// 是否上传
        /// </summary>
        public string isUpApi { get; set; }

        /// <summary>
        /// 数据来源 1在线listting,2订单,3刊登,4, 手工添加
        /// </summary>
        public string source { get; set; }

        /// <summary>
        /// 失败原因
        /// </summary>
        public string errorMsg { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public string createUser { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime createTime { get; set; }
    }
}
