﻿using log4net;
using log4net.Appender;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace ApiControl
{
    public class LoggerHelper
    {
        static readonly ILog loginfo = LogManager.GetLogger("loginfo");
        static readonly ILog logerror = LogManager.GetLogger("logerror");
        static readonly ILog logmonitor = LogManager.GetLogger("logmonitor");

        public static void Error(string ErrorMsg, Exception ex = null)
        {
            if (ex != null)
            {
                logerror.Error(ErrorMsg, ex);
            }
            else
            {
                logerror.Error(ErrorMsg);
            }
        }

        public static void Info(string Msg)
        {
            loginfo.Info(Msg);
        }

        public static void Monitor(string Msg, string SystemKey = "")
        {
            if(!string.IsNullOrWhiteSpace(SystemKey))
            {
                var storedPath = LogManager.GetRepository();
                var appenders = storedPath.GetAppenders();
                if (appenders == null) return;
                foreach (var app in appenders)
                {
                    if (app.Name.Equals("MonitorAppender"))
                    {
                        var ra = app as RollingFileAppender;
                        int index = ra.File.IndexOf("\\LogMonitor");
                        ra.File = ra.File.Substring(0, index) + $"\\LogMonitor\\{SystemKey}\\";
                        ra.ActivateOptions();
                        break;
                    }
                }
            }
            logmonitor.Info(Msg);
        }
    }
}