﻿using System.Web;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;

namespace ApiControl
{
    public class CommonBaseLib
    {
        /// <summary>
        /// 实体转JSON字符窜
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public static string GetJsonToString(object model)
        {
            var jSetting = new JsonSerializerSettings { NullValueHandling = NullValueHandling.Ignore };
            jSetting.Converters.Add(new IsoDateTimeConverter() { DateTimeFormat = "yyyy-MM-dd hh:mm:ss" });
            var json = JsonConvert.SerializeObject(model, Formatting.None, jSetting);
            return json;
        }

        /// <summary>
        /// Json字符窜转为实体
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="value"></param>
        /// <returns></returns>
        public static T GetJsonToObject<T>(string value)
        {
            var jSetting = new JsonSerializerSettings { NullValueHandling = NullValueHandling.Ignore };
            var model = JsonConvert.DeserializeObject<T>(value, jSetting);
            return model;
        }

        /// <summary>
        /// Url编码
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string UrlToEncode(string str)
        {
            return HttpUtility.UrlEncode(str);
        }

        /// <summary>
        /// Url解码
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string UrlToDecode(string str)
        {
            return HttpUtility.UrlDecode(str);
        }

        /// <summary>
        /// 实体转Json并Url编码
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public static string EncodeAndJson(object model)
        {
            string strJson = GetJsonToString(model);
            string enString = UrlToEncode(strJson);
            return enString;
        }

        /// <summary>
        /// 实体转Json并Url编码
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public static T DecodeAndObject<T>(string str)
        {
            string deString = UrlToDecode(str);
            var model = GetJsonToObject<T>(deString);
            return model;
        }
    }
}
