/*??????????*/


















 



using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using PetaPoco;

namespace DbConn
{

	public partial class DbConnDB : Database
	{
		public DbConnDB() 
			: base("DbConn")
		{
			CommonConstruct();
		}

		public DbConnDB(string connectionStringName) 
			: base(connectionStringName)
		{
			CommonConstruct();
		}
		
		partial void CommonConstruct();
		
		public interface IFactory
		{
			DbConnDB GetInstance();
		}
		
		public static IFactory Factory { get; set; }
        public static DbConnDB GetInstance()
        {
			if (_instance!=null)
				return _instance;
				
			if (Factory!=null)
				return Factory.GetInstance();
			else
				return new DbConnDB();
        }

		[ThreadStatic] static DbConnDB _instance;
		
		public override void OnBeginTransaction()
		{
			if (_instance==null)
				_instance=this;
		}
		
		public override void OnEndTransaction()
		{
			if (_instance==this)
				_instance=null;
		}
        

		public class Record<T> where T:new()
		{
			/// <summary>
            /// DB - LINK
            /// </summary>
            public static Database PocoDb
            {
                get
                {
				    return GetInstance();
                    //return new PetaPoco.Database("DbConn");
                }
            }
			/// <summary>
            /// Create
            /// </summary>
            /// <param name="obj"></param>
            /// <returns></returns>
            public static T Func_Create(T obj)
            {
                PocoDb.Insert(obj);
                return obj;
            }
            /// <summary>
            /// DELETE
            /// </summary>
            /// <param name="obj"></param>
            /// <returns></returns>
            public static bool Func_Del(T obj)
            {
                return PocoDb.Delete(obj) > 0;
            }
			/// <summary>
			/// DELETE ByPrimaryKey
			/// </summary>
			/// <param name="primaryKey"></param>
			/// <returns></returns>
			public static int Func_Del(object primaryKey) 
			{
				return PocoDb.Delete<T>(primaryKey);
			}
			/// <summary>
			/// Get By primaryKey
			/// </summary>
			/// <param name="primaryKey"></param>
			/// <returns></returns>
			public static T Func_GetById(object primaryKey)
			{
				return PocoDb.SingleOrDefault<T>(primaryKey); 
			}
            /// <summary>
            /// Update
            /// </summary>
            /// <param name="obj"></param>
            /// <returns></returns>
            public static bool Func_Update(T obj)
            {
                return PocoDb.Update(obj) > 0;
            }
			public static DbConnDB repo { get { return DbConnDB.GetInstance(); } }
			public bool IsNew() { return repo.IsNew(this); }
			public object Insert() { return repo.Insert(this); }

			public void Save() { repo.Save(this); }
			public int Update() { return repo.Update(this); }


		    /// <summary>
            /// add by model
            /// </summary>
            /// <param name="data"></param>
            /// <returns></returns>
            public static T Insert(T data) { repo.Insert(data); return data; }
            /// <summary>
            /// update by model
            /// </summary>
            /// <param name="data"></param>
            /// <returns></returns>
            public static int Update(T data) { return repo.Update(data); }
            /// <summary>
            ///  query one key where id=@0
            /// </summary>
            /// <param name="data"></param>
            /// <returns></returns>
            public static R Find<R>(string sql, params object[] args) { return repo.ExecuteScalar<R>(sql, args); }
            /// <summary>
            ///  query one key where id=@0
            /// </summary>
            /// <param name="data"></param>
            /// <returns></returns>
            public static R Find<R>(Sql sql) { return repo.ExecuteScalar<R>(sql); }

			public int Update(IEnumerable<string> columns) { return repo.Update(this, columns); }
			public static int Update(string sql, params object[] args) { return repo.Update<T>(sql, args); }
			public static int Update(Sql sql) { return repo.Update<T>(sql); }
			public int Delete() { return repo.Delete(this); }
			public static int Delete(string sql, params object[] args) { return repo.Delete<T>(sql, args); }
			public static int Delete(Sql sql) { return repo.Delete<T>(sql); }
			public static int Delete(object primaryKey) { return repo.Delete<T>(primaryKey); }
			public static bool Exists(object primaryKey) { return repo.Exists<T>(primaryKey); }
			public static bool Exists(string sql, params object[] args) { return repo.Exists<T>(sql, args); }
			public static T SingleOrDefault(object primaryKey) { return repo.SingleOrDefault<T>(primaryKey); }
			public static T SingleOrDefault(string sql, params object[] args) { return repo.SingleOrDefault<T>(sql, args); }
			public static T SingleOrDefault(Sql sql) { return repo.SingleOrDefault<T>(sql); }
			public static T FirstOrDefault(string sql, params object[] args) { return repo.FirstOrDefault<T>(sql, args); }
			public static T FirstOrDefault(Sql sql) { return repo.FirstOrDefault<T>(sql); }
			public static T Single(object primaryKey) { return repo.Single<T>(primaryKey); } 
			public static T Single(string sql, params object[] args) { return repo.Single<T>(sql, args); }
			public static T Single(Sql sql) { return repo.Single<T>(sql); }
			public static T First(string sql, params object[] args) { return repo.First<T>(sql, args); }
			public static T First(Sql sql) { return repo.First<T>(sql); }
			public static List<T> Fetch(string sql, params object[] args) { return repo.Fetch<T>(sql, args); }
			public static List<T> Fetch(Sql sql) { return repo.Fetch<T>(sql); }
			public static List<T> Fetch(long page, long itemsPerPage, string sql, params object[] args) { return repo.Fetch<T>(page, itemsPerPage, sql, args); }
			public static List<T> Fetch(long page, long itemsPerPage, Sql sql) { return repo.Fetch<T>(page, itemsPerPage, sql); }
			public static List<T> SkipTake(long skip, long take, string sql, params object[] args) { return repo.SkipTake<T>(skip, take, sql, args); }
			public static List<T> SkipTake(long skip, long take, Sql sql) { return repo.SkipTake<T>(skip, take, sql); }
			public static Page<T> Page(long page, long itemsPerPage, string sql, params object[] args) { return repo.Page<T>(page, itemsPerPage, sql, args); }
			public static Page<T> Page(long page, long itemsPerPage, Sql sql) { return repo.Page<T>(page, itemsPerPage, sql); }
			public static IEnumerable<T> Query(string sql, params object[] args) { return repo.Query<T>(sql, args); }
			public static IEnumerable<T> Query(Sql sql) { return repo.Query<T>(sql); }

		}

	}
	
 
}

 

