﻿using ApiControl;
using CommonControl;
using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Sku.BLL.DataMigrationServices
{
    public class DengYuCategoryExport
    {
        public static void ExportDengYuCategory()
        {
            var resultJson = ApiControl.HttpGetOrPost.httpGet("http://api.pyl.com.cn/api/v1/categories?access_token=32368d93890c6ffa8043c5a3fb1df45c");
            var result = CommonBaseLib.GetJsonToObject<DengYuCategoryResult>(resultJson);
            if(result.code == 200 && result.data != null)
            {
                DataTable dt = new DataTable();
                dt.Columns.Add("底层id");
                dt.Columns.Add("名称级别1");
                dt.Columns.Add("名称级别2");
                dt.Columns.Add("名称级别3");
                dt.Columns.Add("名称级别4");
                dt.Columns.Add("名称级别5");
                dt.Columns.Add("名称级别6");

                string virtualPath = $"/ExprotFile/ExprotProduct/导出登宇分类.csv";
                string fullFileName = System.Web.HttpContext.Current.Server.MapPath("~" + virtualPath);
                //创建文件夹，保存文件
                string path = Path.GetDirectoryName(fullFileName);
                if (path != null) Directory.CreateDirectory(path);
                
                foreach (var item in result.data)
                {
                    var cateFullName = item.categoryName;
                    dt = RecursionCategoryList(dt, item.children, cateFullName);
                }
                ExcelUtil.SaveCSV(dt, fullFileName);
            }
        }

        /// <summary>
        /// 递归获取分类列表
        /// </summary>
        private static DataTable RecursionCategoryList(DataTable dt,List<DengYuCategory> cateList, string cateFullName)
        {
            foreach(var item in cateList)
            {
                var tempFullName = cateFullName + "," + item.categoryName;
                if (item.children.Count > 0)
                {
                    dt = RecursionCategoryList(dt, item.children, tempFullName);
                }
                else
                {
                    var cateNameArr = tempFullName.Split(',');
                    DataRow row = dt.NewRow();
                    row["底层id"] = item.id;
                    int num = 1;
                    foreach(var name in cateNameArr)
                    {
                        row[$"名称级别{num}"] = name;
                        num++;
                    }
                    dt.Rows.Add(row);
                }
            }
            return dt;
        }
    }

    public class DengYuCategoryResult
    {
        /// <summary>
        /// 返回代码
        /// </summary>
        public int code { get; set; }

        /// <summary>
        /// 描述
        /// </summary>
        public string msg { get; set; }

        /// <summary>
        /// 数据
        /// </summary>
        public List<DengYuCategory> data { get; set; }
    }

    public class DengYuCategory
    {
        /// <summary>
        /// 分类Id
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 分类名称
        /// </summary>
        public string categoryName { get; set; }

        /// <summary>
        /// 子节点
        /// </summary>
        public List<DengYuCategory> children { get; set; }
    }
}
