﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Petapoco.Custom.HqygDto
{
    public class ApiProductAdd
    {
        /// <summary>
        /// 平台编码    
        /// </summary>
        public string company { get; set; }

        /// <summary>
        /// 接口名   
        /// </summary>
        public string method { get; set; }

        /// <summary>
        /// 产品编码   
        /// </summary>
        public string goods_sn { get; set; }

        /// <summary>
        /// 商品编码   
        /// </summary>
        public string product_sn { get; set; }

        /// <summary>
        /// 产品分类ID    
        /// </summary>
        public int category_id { get; set; }

        /// <summary>
        /// 充电器规格：1：无2：美规3：英规4：欧规5：澳规6：德规7：中规   
        /// </summary>
        public string charger_spec { get; set; }

        /// <summary>
        /// 颜色、尺寸(颜色必传，尺寸可选，且都必须为英文，可以上传多个组合，不能超过10个   
        /// </summary>
        public List<ProductSandard> specs { get; set; }

        /// <summary>
        /// 中文申报品名   
        /// </summary>
        public string declare_name_cn { get; set; }

        /// <summary>
        /// 英文申报品名   
        /// </summary>
        public string declare_name_en { get; set; }

        /// <summary>
        /// 海关编码（A-Za-z0-9字符）   
        /// </summary>
        public string custom_sn { get; set; }

        /// <summary>
        /// 产品性质（多个id逗号隔开）   
        /// </summary>
        public string character_ids { get; set; }   

        public class ProductSandard
        {
            /// <summary>
            /// 标识id   
            /// </summary>
            public int id { get; set; }

            /// <summary>
            /// 产品中文名称   
            /// </summary>
            public string product_name { get; set; }

            /// <summary>
            /// 产品英文名称   
            /// </summary>
            public string product_name_en { get; set; }

            /// <summary>
            /// 产品重量，产品净重，不含包装   
            /// </summary>
            public decimal product_weight { get; set; }

            /// <summary>
            /// 实际重量=产品净重+产品本身包装   
            /// </summary>
            public decimal actual_weight { get; set; }

            /// <summary>
            /// 采购价   
            /// </summary>
            public decimal purchase_price { get; set; }

            /// <summary>
            /// 采购价币种   
            /// </summary>
            public string currency_code { get; set; }

            /// <summary>
            /// 产品尺寸长   
            /// </summary>
            public decimal product_length { get; set; }

            /// <summary>
            /// 产品尺寸宽   
            /// </summary>
            public decimal product_width { get; set; }

            /// <summary>
            /// 产品尺寸高   
            /// </summary>
            public decimal product_height { get; set; }

            /// <summary>
            /// 包装尺寸长   
            /// </summary>
            public decimal package_length { get; set; }

            /// <summary>
            /// 包装尺寸宽   
            /// </summary>
            public decimal package_width { get; set; }

            /// <summary>
            /// 包装尺寸高   
            /// </summary>
            public decimal package_height { get; set; }

            /// <summary>
            /// 主图JPG格式   
            /// </summary>
            public string image_path { get; set; }

            /// <summary>
            /// 颜色   
            /// </summary>
            public string color { get; set; }

            /// <summary>
            /// 尺寸   
            /// </summary>
            public string size { get; set; }
        }

    }
}
