﻿using ApiControl;
using BailunRedis.ProductInfo;
using Newtonsoft.Json;
using Petapoco.Custom.HqygDto;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text.RegularExpressions;
using System.Web;

namespace API.Services.HqygManageServices
{
    public class HqygDataServices
    {
        public static string code = "SYB0013";
        public static string key = "d71c26@abebad%bce64*!28bb6fea<";
        public static string hqygou = System.Configuration.ConfigurationManager.AppSettings["hqygou"];

        /// <summary>
        /// 公用获取API数据（环球易购）
        /// </summary>
        /// <param name="method"></param>
        /// <returns></returns>
        public static List<ProductBaseList> GetProductCommon(string method)
        {
            int i = 0;
            List<ProductBaseList> dataList = new List<ProductBaseList>();
            List<ProductBaseList> dataTemp = new List<ProductBaseList>();
            APICommonGet obj = new APICommonGet();
            while (dataTemp.Count == 0)
            {
                dataTemp = GetProductCommonBase(obj, method, i);
                i++;
                if (dataTemp.Count > 0)
                    dataList.AddRange(dataTemp);
            }
            return dataList;
        }

        /// <summary>
        /// 获取产品基础信息公共接口
        /// </summary>
        /// <returns></returns>
        public static List<ProductBaseList> GetProductCommonBase(APICommonGet obj, string method, int? page = 0)
        {
            obj.company = code;
            obj.method = GetApiName(method);
            obj.page = page;

            var jSetting = new JsonSerializerSettings { NullValueHandling = NullValueHandling.Ignore };
            var json = JsonConvert.SerializeObject(obj, Formatting.None, jSetting);
            var strJson = GetDataCommon(json);
            var myObj = JsonConvert.DeserializeObject<ProductBaseDto>(strJson);
            if (myObj.response)
            {
                var list = myObj.result.lists.ToList();
                return list;
            }
            else
            {
                return new List<ProductBaseList>();
            }
        }

        public static string GetRedisName(string method)
        {
            switch (method)
            {
                case "category":
                    return CacheKey.NewProductCategories;  // 获取产品分类
                case "currency":
                    return CacheKey.Currency;  // 获取系统币种
                case "character":
                    return CacheKey.ProductProperties;  // 获取产品性质
                default:
                    return "";
            }
        }

        private static string GetApiName(string apiMethod)
        {
            switch (apiMethod)
            {
                case "category":
                    return "get.Category.Base";  // 获取产品分类
                case "currency":
                    return "get.Currency.Base";  // 获取系统币种
                case "character":
                    return "get.Character.Base";  // 获取产品性质
                default:
                    return "";
            }
        }

        /// <summary>
        /// 上传图片
        /// </summary>
        /// <returns></returns>
        public static string UploadFileImage(string imgUrl)
        {
            if (string.IsNullOrWhiteSpace(imgUrl))
            {
                return "";
            }
            //string imgUrl = @"E:\meinv.jpg";
            HttpGetOrPost myImg = new HttpGetOrPost();
            //将图片转化为byte[]再转化为string
            string array = "data:image/jpg;base64," + Convert.ToBase64String(myImg.ImageToByteArray(imgUrl));

            APICommonGet obj = new APICommonGet();
            obj.company = code;
            obj.method = "upload.File.Image";
            obj.image = array;

            var jSetting = new JsonSerializerSettings { NullValueHandling = NullValueHandling.Ignore };
            var json = JsonConvert.SerializeObject(obj, Formatting.None, jSetting);
            var strJson = GetDataCommon(json);
            var myObj = JsonConvert.DeserializeObject<ProductBaseDto>(strJson);
            if (myObj.response)
            {
                var strUrl = myObj.result.file_path;
                return strUrl;
            }
            else
            {
                return "";
            }
        }

        #region 公共获取接口方法


        /// <summary>
        ///  产品库公用接口方法
        /// </summary>
        /// <param name="strJson"></param>
        /// <returns></returns>
        public static string GetDataCommon(string strJson)
        {
            //string encodeJson = HttpUtility.UrlEncode(strJson);
            //var key_code = Security.md5Encrypt(code + Security.md5Encrypt(key + strJson));
            //var paraUrl = string.Format("key={0}&data={1}", key_code, encodeJson);
            //var strResult = Regex.Unescape(HttpGetOrPost.httpPost(hqygou, paraUrl));
            //return strResult;



            string resStrJson = HttpGetOrPost.httpGet("http://oa.bailuntec.com/api/Currency/GetCurrency");
            List<SetCategoryCurrencysByOADto> resultList = JsonConvert.DeserializeObject<List<SetCategoryCurrencysByOADto>>(resStrJson);
            ProductBaseDto result = new ProductBaseDto();
            result.response = true;
            result.result = new ProductInfo();
            result.result.lists = new List<ProductBaseList>();
            ProductBaseList tempProductBaseList = null;
            resultList.ForEach(item =>
            {
                tempProductBaseList = new ProductBaseList { currency_code= item.currencyCode,category_name=item.currencyName };
                result.result.lists.Add(tempProductBaseList);
            });
            return JsonConvert.SerializeObject(result);

        }
        #endregion
    }

    public class SetCategoryCurrencysByOADto
    {
        /// <summary>
        /// 
        /// </summary>
        public string currencyCode { get; set; }

        /// <summary>
        /// 人民币
        /// </summary>
        public string currencyName { get; set; }
    }
}
